package com.xforceplus.dao;

import com.xforceplus.entity.TenantPolicy;
import org.springframework.data.jpa.repository.JpaRepository;
import org.springframework.data.jpa.repository.JpaSpecificationExecutor;
import org.springframework.data.jpa.repository.Modifying;
import org.springframework.data.jpa.repository.Query;
import org.springframework.data.repository.query.Param;

import java.util.List;


/**
 * @author : geewit
 * Date: 19-12-03
 */
public interface TenantPolicyDao extends JpaRepository<TenantPolicy, Long>, JpaSpecificationExecutor<TenantPolicy> {
    @Override
    @Modifying(clearAutomatically = true)
    @Query("delete from TenantPolicy tp where tp.id = :id")
    void deleteById(@Param("id") Long id);

    @Query("select tp from TenantPolicy tp where tp.tenantId = :tenantId")
    List<TenantPolicy> findPoliciesMapByTenantId(@Param("tenantId") long tenantId);

    @Query("select tp from TenantPolicy tp where tp.tenantId = :tenantId and tp.name = :name")
    List<TenantPolicy> findPoliciesByTenantIdAndName(@Param("tenantId") long tenantId, @Param("name") String name);
}
