/*
 * Copyright (c)  2015~2021, xforceplus
 * All rights reserved.
 * Project:tenant-service
 * Id: CompanyExtendDao.java   2021-01-04 14-24-32
 * Author: Evan
 */
package com.xforceplus.dao.company;

import com.xforceplus.dto.company.CompanyServicePackageDTO;

import java.util.List;
import java.util.Set;

/**
 * <p>
 * Title:  公司扩展查询
 * </p>
 * <p>
 * Description: 公司扩展查询
 * </p>
 * <p>
 * Copyright: 2015~2021
 * </p>
 * <p>
 * Company/Department: xforceplus
 * </p>
 *
 * @author Evan
 * <b>Creation Time:</b> 2021-01-04 14-24-32
 * @since V1.0
 */
public interface CompanyExtendDao {
    /**
     * 根据公司ID查询信息
     * @param companyIds 公司ID集合
     * @return  List<CompanyServicePackageDTO>
     */
    List<CompanyServicePackageDTO> findCompanyServicePackageByCompanyIds(Set<Long> companyIds);
}
