/*
 * Copyright (c)  2015~2021, xforceplus
 * All rights reserved.
 * Project:tenant-service
 * Id: CompanyHisDao.java   2021-01-12 15-56-48
 * Author: Evan
 */
package com.xforceplus.dao.company;

import com.xforceplus.domain.company.CompanyHisDTO;
import com.xforceplus.entity.Company;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.data.repository.NoRepositoryBean;

import java.util.Optional;

/**
 * <p>
 * Title: CompanyHis Dao接口定义
 * </p>
 * <p>
 * Description: CompanyHis Dao接口定义
 * </p>
 * <p>
 * Copyright: 2015~2021
 * </p>
 * <p>
 * Company/Department: xforceplus
 * </p>
 *
 * @author Evan
 * <b>Creation Time:</b> 2021-01-12 15-56-48
 * @since V1.0
 */
@NoRepositoryBean
public interface CompanyHisExtendDao {

    /**
     * 根据公司履历的税号查询当前公司信息
     *
     * @param taxNum 税号
     * @return Optional<Company>
     */
    Optional<Company> findCompanyByHisTaxNum(String taxNum);

    /**
     * 按税号查询公司履历当前的信息
     * @param taxNum  税号
     * @param pageable 分页
     * @return  Page<Company>
     */
    Page<Company> page(String taxNum, Pageable pageable);

    /**
     * 按税号查询公司修改的履历信息
     * @param taxNum 税号
     * @param pageable 分页
     * @return  Page<CompanyHisDTO
     */
    Page<CompanyHisDTO> hisPageByTaxNum(String taxNum, Pageable pageable);
}
