/*
 * Copyright (c)  2015~2021, xforceplus
 * All rights reserved.
 * Project:tenant-service
 * Id: CompanyExtendDaoImpl.java   2021-01-04 14-37-04
 * Author: Evan
 */
package com.xforceplus.dao.company.impl;

import com.xforceplus.dao.company.CompanyExtendDao;
import com.xforceplus.data.query.StringQuery;
import com.xforceplus.data.repository.AbstractDefaultJpaRepositoryImpl;
import com.xforceplus.dto.company.CompanyServicePackageDTO;
import org.springframework.stereotype.Repository;
import org.springframework.util.Assert;

import java.util.List;
import java.util.Set;

/**
 * <p>
 * Title: 公司扩展查询实现类
 * </p>
 * <p>
 * Description: 公司扩展查询实现类
 * </p>
 * <p>
 * Copyright: 2015~2021
 * </p>
 * <p>
 * Company/Department: xforceplus
 * </p>
 *
 * @author Evan
 * <b>Creation Time:</b> 2021-01-04 14-37-04
 * @since V1.0
 */
@Repository
public class CompanyExtendDaoImpl extends AbstractDefaultJpaRepositoryImpl implements CompanyExtendDao {

    /**
     * 按公司IDs查询公司服务包
     */
    private static final String  SQL_SERVICE_PACKAGE_BY_COMPANY_IDS="select bcsr.company_id,bsp.service_package_id,bsp.service_package_name  " +
            " from bss_company_service_rel bcsr,bss_service_package bsp " +
            " where bcsr.service_package_id=bsp.service_package_id " +
            " and bcsr.company_id in(:companyIds)";

    /**
     * 根据公司ID查询信息
     *
     * @param companyIds 公司ID集合
     * @return List<CompanyServicePackageDTO>
     */
    @Override
    public List<CompanyServicePackageDTO> findCompanyServicePackageByCompanyIds(Set<Long> companyIds) {
        Assert.notEmpty(companyIds,"公司IDS集合不能为空");
        StringQuery stringQuery=StringQuery.builder().query(SQL_SERVICE_PACKAGE_BY_COMPANY_IDS)
                .predicate(true)
                .param("companyIds",companyIds).build();
        return this.findBySql(stringQuery,CompanyServicePackageDTO.class,Boolean.TRUE);
    }
}
