/*
 * Copyright (c)  2015~2021, xforceplus
 * All rights reserved.
 * Project:tenant-service
 * Id: CompanyExtendsHisDaoImpl.java   2021-01-12 16-14-02
 * Author: Evan
 */
package com.xforceplus.dao.company.impl;

import com.xforceplus.dao.company.CompanyHisExtendDao;
import com.xforceplus.data.query.StringQuery;
import com.xforceplus.data.repository.AbstractDefaultJpaRepositoryImpl;
import com.xforceplus.domain.company.CompanyHisDTO;
import com.xforceplus.dto.resource.ServicePackageDTO;
import com.xforceplus.entity.Company;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Repository;
import org.springframework.util.Assert;
import org.springframework.util.CollectionUtils;

import java.util.List;
import java.util.Optional;

/**
 * <p>
 * Title:
 * </p>
 * <p>
 * Description:
 * </p>
 * <p>
 * Copyright: 2015~2021
 * </p>
 * <p>
 * Company/Department: xforceplus
 * </p>
 *
 * @author Evan
 * <b>Creation Time:</b> 2021-01-12 16-14-02
 * @since V1.0
 */
@Repository
public class CompanyHisExtendDaoImpl extends AbstractDefaultJpaRepositoryImpl implements CompanyHisExtendDao {
    /**
     *
     */
    private  static final int EFFECTIVE_VALID=1;
    /**
     * 按公司IDs查询公司服务包
     */
    private static final String  SQL_COMPANY_HIS_TAX_NUM="select bc.* from bss_company bc where bc.company_id = " +
            " (select company_id from bss_company_audit  bca  where   " +
            " bca.is_effective=:effective and bca.tax_num=:taxNum  LIMIT 1)";


    /**
     * 按公司IDs查询公司服务包
     */
    private static final String  SQL_COMPANY_HIS_TAX_NUM_PAGE="select bc.* from bss_company bc where bc.company_id in " +
            " (select company_id from bss_company_audit  bca  where   " +
            " bca.is_effective=:effective and bca.tax_num=:taxNum)";

    /**
     * 查询公司历史记录
     */
    private static final String SQL_COMPANY_HIS_BY_TAX_NUM="select bca.company_id,bca.company_name,bca.tax_num," +
            "bca.effective_date,bca.is_effective as effective from bss_company_audit  bca where bca.tax_num=:taxNum";

    @Override
    public Optional<Company> findCompanyByHisTaxNum(String taxNum) {
        Assert.hasText(taxNum,"税号不为空");
        StringQuery stringQuery=StringQuery.builder().query(SQL_COMPANY_HIS_TAX_NUM)
                .predicate(true)
                .param("taxNum",taxNum)
                .param("effective",EFFECTIVE_VALID)
                .build();
        List<Company>  companyList=this.findBySql(stringQuery, Company.class,Boolean.TRUE);
        if(CollectionUtils.isEmpty(companyList)){
            return Optional.empty();
        }
        return Optional.ofNullable(companyList.get(0));
    }


    /**
     * 按税号查询公司修改的履历信息
     *
     * @param taxNum   税号
     * @param pageable 分页
     * @return Page<CompanyHisDTO
     */
    @Override
    public Page<CompanyHisDTO> hisPageByTaxNum(String taxNum, Pageable pageable) {
        Assert.hasText(taxNum,"税号不为空");
        StringQuery stringQuery=StringQuery.builder().query(SQL_COMPANY_HIS_BY_TAX_NUM)
                .predicate(true)
                .param("taxNum",taxNum)
                .build();
        return super.pagingSqlBy(pageable, stringQuery.getQuery(), stringQuery.getParams(), CompanyHisDTO.class, Boolean.TRUE);
    }

    /**
     * @param taxNum
     * @param pageable
     * @return Page<Company>
     */
    @Override
    public Page<Company> page(String taxNum, Pageable pageable) {
        Assert.hasText(taxNum,"税号不为空");
        StringQuery stringQuery=StringQuery.builder().query(SQL_COMPANY_HIS_TAX_NUM_PAGE)
                .predicate(true)
                .param("taxNum",taxNum)
                .param("effective",EFFECTIVE_VALID)
                .build();
        return super.pagingSqlBy(pageable, stringQuery.getQuery(), stringQuery.getParams(), Company.class, Boolean.TRUE);
    }
}
