package com.xforceplus.dao.impl;

import com.xforceplus.api.model.CompanyModel.Request.CompanyPackageQuery;
import com.xforceplus.dao.CustomizedCompanyDao;
import com.xforceplus.domain.company.CompanyPackage;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageImpl;
import org.springframework.data.domain.Pageable;

import javax.persistence.EntityManager;
import javax.persistence.PersistenceContext;
import javax.persistence.TypedQuery;
import java.util.ArrayList;
import java.util.List;

/**
 * 产品服务包Dao
 *
 * @author geewit
 */
@SuppressWarnings({"all"})
public class CustomizedCompanyDaoImpl implements CustomizedCompanyDao {
    private final static Logger logger = LoggerFactory.getLogger(CustomizedCompanyDaoImpl.class);

    @PersistenceContext
    private EntityManager entityManager;

    @Override
    public Page<CompanyPackage> findPackages(CompanyPackageQuery query, Pageable pageable) {

        StringBuilder selectBuilder = new StringBuilder("select new com.xforceplus.domain.company.CompanyPackage(csr.id, csr.tenantId, csr.tenant.tenantCode, csr.tenant.tenantName, csr.companyId, csr.company.companyName, csr.company.taxNum, csr.status, csr.createUserName, csr.createTime) from com.xforceplus.entity.CompanyServiceRel csr");
        StringBuilder countBuilder = new StringBuilder("select count(distinct csr.companyId) from com.xforceplus.entity.CompanyServiceRel csr join csr.tenant join csr.company");
        StringBuilder groupByBuilder = new StringBuilder(" group by csr.companyId");
        StringBuilder queryBuilder = new StringBuilder();
        if (query != null) {
            boolean hasParam = false;
            if (query.getCompanyId() != null) {
                queryBuilder.append(" where");
                queryBuilder.append(" csr.companyId = :companyId");
                hasParam = true;
            }
            if (StringUtils.isNotBlank(query.getTaxNum())) {
                if (hasParam) {
                    queryBuilder.append(" and");
                } else {
                    queryBuilder.append(" where");
                }
                queryBuilder.append(" csr.company.taxNum = :taxNum");
                hasParam = true;
            }
            if (StringUtils.isNotBlank(query.getCompanyName())) {
                if (hasParam) {
                    queryBuilder.append(" and");
                } else {
                    queryBuilder.append(" where");
                }
                queryBuilder.append(" csr.company.companyName like :companyName");
                hasParam = true;
            }
            if (query.getTenantId() != null) {
                if (hasParam) {
                    queryBuilder.append(" and");
                } else {
                    queryBuilder.append(" where");
                }
                queryBuilder.append(" csr.tenantId = :tenantId");
                hasParam = true;
            }
            if (StringUtils.isNotBlank(query.getTenantCode())) {
                if (hasParam) {
                    queryBuilder.append(" and");
                } else {
                    queryBuilder.append(" where");
                }
                queryBuilder.append(" csr.tenant.tenantCode = :tenantCode");
                hasParam = true;
            }
            if (StringUtils.isNotBlank(query.getTenantName())) {
                if (hasParam) {
                    queryBuilder.append(" and");
                } else {
                    queryBuilder.append(" where");
                }
                queryBuilder.append(" csr.tenant.tenantName like :tenantName");
                hasParam = true;
            }
            if (query.getServicePackageId() != null && query.getServicePackageId() > 0) {
                if (hasParam) {
                    queryBuilder.append(" and");
                } else {
                    queryBuilder.append(" where");
                }
                queryBuilder.append(" csr.servicePackage.servicePackageId = :servicePackageId");
                hasParam = true;
            }
            if (StringUtils.isNotBlank(query.getServicePackageName())) {
                if (hasParam) {
                    queryBuilder.append(" and");
                } else {
                    queryBuilder.append(" where");
                }
                queryBuilder.append(" csr.servicePackage.servicePackageName like :servicePackageName");
                hasParam = true;
            }
            if (query.getStatus() != null) {
                if (hasParam) {
                    queryBuilder.append(" and");
                } else {
                    queryBuilder.append(" where");
                }
                queryBuilder.append(" csr.status = :status");
            }
        }
        selectBuilder.append(queryBuilder).append(groupByBuilder).append(" order by csr.id desc");
        countBuilder.append(queryBuilder);
        String selectHql = selectBuilder.toString();
        logger.info("selectHQL = {}", selectHql);
        TypedQuery<CompanyPackage> selectQuery = entityManager.createQuery(selectHql, CompanyPackage.class);
        String countHql = countBuilder.toString();
        logger.info("countHQL = {}", countHql);
        TypedQuery<Long> countQuery = entityManager.createQuery(countHql, Long.class);
        if (query != null) {
            if (query.getCompanyId() != null) {
                selectQuery.setParameter("companyId", query.getCompanyId());
                countQuery.setParameter("companyId", query.getCompanyId());
            }
            if (StringUtils.isNotBlank(query.getTaxNum())) {
                selectQuery.setParameter("taxNum", query.getTaxNum());
                countQuery.setParameter("taxNum", query.getTaxNum());
            }
            if (StringUtils.isNotBlank(query.getCompanyName())) {
                selectQuery.setParameter("companyName", query.getCompanyName() + "%");
                countQuery.setParameter("companyName", query.getCompanyName() + "%");
            }
            if (query.getTenantId() != null) {
                selectQuery.setParameter("tenantId", query.getTenantId());
                countQuery.setParameter("tenantId", query.getTenantId());
            }
            if (StringUtils.isNotBlank(query.getTenantCode())) {
                selectQuery.setParameter("tenantCode", query.getTenantCode());
                countQuery.setParameter("tenantCode", query.getTenantCode());
            }
            if (StringUtils.isNotBlank(query.getTenantName())) {
                selectQuery.setParameter("tenantName", query.getTenantName() + "%");
                countQuery.setParameter("tenantName", query.getTenantName() + "%");
            }
            if (query.getServicePackageId() != null && query.getServicePackageId() > 0) {
                selectQuery.setParameter("servicePackageId", query.getServicePackageId());
                countQuery.setParameter("servicePackageId", query.getServicePackageId());
            }
            if (StringUtils.isNotBlank(query.getServicePackageName())) {
                selectQuery.setParameter("servicePackageName", "%" + query.getServicePackageName() + "%");
                countQuery.setParameter("servicePackageName", "%" + query.getServicePackageName() + "%");
            }
            if (query.getStatus() != null) {
                selectQuery.setParameter("status", query.getStatus());
                countQuery.setParameter("status", query.getStatus());
            }
        }
        long totalCount = countQuery.getSingleResult();
        logger.info("totalCount = {}", totalCount);
        int startIndex = pageable.getPageNumber() * pageable.getPageSize();
        if (startIndex > totalCount) {
            return new PageImpl<>(new ArrayList<>(), pageable, totalCount);
        }
        selectQuery.setFirstResult(startIndex);
        selectQuery.setMaxResults(pageable.getPageSize());
        List<CompanyPackage> list = selectQuery.getResultList();
        Page<CompanyPackage> page = new PageImpl<>(list, pageable, totalCount);
        return page;
    }
}
