package com.xforceplus.dao.impl;

import com.xforceplus.api.model.OrgVirtualModel;
import com.xforceplus.dao.CustomizedOrgVirtualDao;
import com.xforceplus.data.query.StringQuery;
import com.xforceplus.data.repository.AbstractDefaultJpaRepositoryImpl;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Repository;
import org.springframework.transaction.annotation.Transactional;

import java.util.List;

/**
 * 虚拟组织
 *
 * @author duanhy
 */
@SuppressWarnings({"all"})
@Repository
public class CustomizedOrgVirtualDaoImpl extends AbstractDefaultJpaRepositoryImpl implements CustomizedOrgVirtualDao {
    private final static Logger logger = LoggerFactory.getLogger(CustomizedOrgVirtualDaoImpl.class);

    @Override
    @Transactional(readOnly = true)
    public List<OrgVirtualModel.Response.ExcelExportModel> listToExcel(OrgVirtualModel.Request.ExcelExportQuery q) {
        StringQuery query =
                StringQuery.builder()
                        .query("SELECT " +
                                " a.*" +
                                " ,b.org_code as org_struct_code" +
                                " ,c.tax_num " +
                                " FROM " +
                                " sys_org_virtual a " +
                                " LEFT JOIN sys_org_struct b ON a.org_struct_id = b.org_struct_id " +
                                " LEFT JOIN bss_company c ON b.company_id = c.company_id " +
                                " WHERE a.tenant_id=:tenantId")
                        .param("tenantId",q.getTenantId())
                        .predicateHasText(q.getOrgName())
                        .query(" and a.org_name = :orgName ")
                        .param("orgName", q.getOrgName())
                        .predicateHasText(q.getOrgCode())
                        .query(" and a.org_code = :orgCode ")
                        .param("orgCode", q.getOrgCode())

                        .predicateNotEmpty(q.getOrgVirtualIds())
                        .query(" and a.org_virtual_id in( :orgVirtualIds) ")
                        .param("orgVirtualIds", q.getOrgVirtualIds())

                        .build();
        return this.findBySql(query, OrgVirtualModel.Response.ExcelExportModel.class, Boolean.TRUE);
    }


}
