/*
 * Copyright (c)  2015~2020, xforceplus
 * All rights reserved.
 * Project:tenant-service
 * Id: ImportFile.java   2020-09-23 17-17-59
 * Author: Evan
 */
package com.xforceplus.entity;

import com.xforceplus.domain.IOperator;
import com.xforceplus.jpa.listener.ExcelFileStorePersistenceListener;
import io.geewit.data.jpa.essential.id.IDGenerators;
import lombok.Getter;
import lombok.Setter;
import lombok.ToString;
import org.hibernate.annotations.DynamicInsert;
import org.hibernate.annotations.DynamicUpdate;
import org.hibernate.annotations.GenericGenerator;

import javax.persistence.*;
import java.io.Serializable;
import java.util.Date;

/**
 * <p>
 * Title:
 * </p>
 * <p>
 * Description:
 * </p>
 * <p>
 * Copyright: 2015~2020
 * </p>
 * <p>
 * Company/Department: xforceplus
 * </p>
 *
 * @author Evan
 * <b>Creation Time:</b> 2020-09-23 17-17-59
 * @since V1.0
 */
@SuppressWarnings("all")
@EntityListeners({ExcelFileStorePersistenceListener.class})
@Setter
@Getter
@ToString
@DynamicInsert
@DynamicUpdate
@Entity
@Table(name = "bss_import_file")
public class ExcelFileStore implements IOperator, Serializable {
    /***
     * 文件导入ID
     */

    @Id
    @Column(name = "id", nullable = false)
    @GeneratedValue(strategy = GenerationType.TABLE, generator = "SnowflakeGenerator")
    @GenericGenerator(name = "SnowflakeGenerator", strategy = IDGenerators.SnowflakeGenerator)
    private Long id;
    /**
     * 导入租户ID
     */
    @Column(name = "tenant_id")
    private Long tenantId;
    /**
     * 用户ID
     */
    @Column(name = "user_id")
    private Long userId;

    /**
     * 导出或入导出类型
     */
    @Column(name = "excel_file_type")
    private Integer excelFileType;
    /**
     * 业务类型
     */
    @Column(name = "business_type")
    private String businessType;
    /***
     * 导入时间
     */
    @Temporal(TemporalType.TIMESTAMP)
    @Column(name = "create_date")
    private Date createDate;

    /***
     * 处理开始时间
     */
    @Temporal(TemporalType.TIMESTAMP)
    @Column(name = "begin_date")
    private Date beginDate;
    /**
     * 处理结束时间
     */
    @Column(name = "end_date")
    @Temporal(TemporalType.TIMESTAMP)
    private Date endDate;

    /***
     * 处理状态：1 未处理，2处理中，3 处理完成
     */
    @Column(name = "status")
    private Integer status;

    /**
     * 处理耗时
     */
    @Column(name="cost_time")
    private Long costTime;

    /***
     * 消息写
     */
    @Column(name="message")
    private String message;

    /***
     * 总记录
     */
    @Column(name="total_size")
    private Integer totalSize;

    /***
     * 成功记录数
     */
    @Column(name="success_size")
    private Integer successSize;

    /***
     * 查询参数
     */
    @Column(name="query_params")
    private String params;

    /***
     * 读取次数 默认值为0
     */
    @Column(name = "read_time")
    private Integer readTime;
    /***
     * 处理结果（0 待处理 2-失败，1 成功,2 部分成功）
     */
    @Column(name = "result_state")
    private Integer resultState;
    /***
     * 源文件fileId
     */
    @Column(name = "source_file_id")
    private  Long sourceFileId;
    /**
     * 目标文件fileId; (即错误文件，写入Error文件)
     */
    @Column(name = "target_file_id")
    private  Long targetFileId;

    /***
     * sourceFileName
     */
    @Column(name = "source_file_name")
    private String sourceFileName;

    /***
     * targetFileName
     */
    @Column(name = "target_file_name")
    private String targetFileName;

    /**
     * 每批处理的数据，默认为：3000
     */
    @Column(name = "batch_size")
    private Integer batchSize;

    /***
     * 创建时间
     */
    @Temporal(TemporalType.TIMESTAMP)
    @Column(name = "create_time",updatable = false)
    private Date createTime;
    /**
     * 更新时间
     */
    @Temporal(TemporalType.TIMESTAMP)
    @Column(name = "update_time",updatable = true)
    private Date updateTime;
    /**
     * 创建人ID
     */
    @Column(name = "creater_id",updatable = false)
    private String createrId;
    /**
     * 更新人名称
     */
    @Column(name = "creater_name",updatable = false)
    private String createrName;
    /**
     * 创建人ID
     */
    @Column(name = "updater_id")
    private String updaterId;
    /**
     * 更新人名称
     */
    @Column(name = "updater_name")
    private String updaterName;
    /**
     *  乐观锁 (用来控制)
     */
    @Version
    @Column(name = "opt_counter")
    private  Integer counter;

}