package com.xforceplus.entity;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonView;
import com.xforceplus.domain.org.OrgExtensionDto;
import com.xforceplus.jpa.listener.OrgExtensionListener;
import io.geewit.core.jackson.view.View;
import io.geewit.data.jpa.essential.id.IDGenerators;
import org.hibernate.annotations.DynamicInsert;
import org.hibernate.annotations.DynamicUpdate;
import org.hibernate.annotations.GenericGenerator;

import javax.persistence.*;
import java.io.Serializable;
import java.util.Date;

@JsonIgnoreProperties(value = {"hibernateLazyInitializer", "handler", "fieldHandler"}, ignoreUnknown = true)
@NamedEntityGraphs({
        @NamedEntityGraph(name = "OrgExtension.graph",
                attributeNodes = {//attributeNodes 来定义需要懒加载的属性
                        @NamedAttributeNode("org")
                }
        )})
@EntityListeners({OrgExtensionListener.class})
@DynamicInsert
@DynamicUpdate
@Entity
@Table(name = "org_extension")
public class OrgExtension extends OrgExtensionDto implements Serializable {

    private Long orgExtensionId;

    @JsonIgnore
    private OrgStruct org;

    @Id
    @Column(name = "org_extension_id", nullable = false)
    @GeneratedValue(strategy = GenerationType.TABLE, generator = "SnowflakeGenerator")
    @GenericGenerator(name = "SnowflakeGenerator", strategy = IDGenerators.SnowflakeGenerator)
    public Long getOrgExtensionId() {
        return orgExtensionId;
    }

    public void setOrgExtensionId(Long orgExtensionId) {
        this.orgExtensionId = orgExtensionId;
    }

    @Override
    @Column(name = "org_struct_id", nullable = false)
    public Long getOrgStructId() {
        return super.getOrgStructId();
    }

    @Override
    @Basic
    @Column(name = "extension_key", nullable = false)
    public String getExtensionKey() {
        return super.getExtensionKey();
    }

    @Override
    @Basic
    @Column(name = "extension_value", nullable = false)
    public String getExtensionValue() {
        return super.getExtensionValue();
    }

    @Override
    @Basic
    @Column(name = "status", nullable = false)
    public Integer getStatus() {
        return status;
    }

    @Override
    @SuppressWarnings("AliMissingOverrideAnnotation")
    @Temporal(TemporalType.TIMESTAMP)
    @Column(name = "create_time")
    public Date getCreateTime() {
        return createTime;
    }

    @Override
    @Basic
    @Column(name = "update_time")
    public Date getUpdateTime() {
        return updateTime;
    }

    @ManyToOne(fetch = FetchType.LAZY)
    @JoinColumn(name = "org_struct_id", referencedColumnName = "org_struct_id", insertable = false, updatable = false, foreignKey = @ForeignKey(value = ConstraintMode.NO_CONSTRAINT))
    public OrgStruct getOrg() {
        return org;
    }

    public void setOrg(OrgStruct org) {
        this.org = org;
    }

    @Override
    @JsonView(View.List.class)
    @Transient
    public String getTenantName() {
        if (super.tenantName == null) {
            super.tenantName = this.org != null ? this.org.getTenantName() : null;
        }
        return super.tenantName;
    }

    @Override
    @JsonView(View.List.class)
    @Transient
    public String getTenantCode() {
        if (super.tenantCode == null) {
            super.tenantCode = this.org != null ? this.org.getTenantCode() : null;
        }
        return super.tenantCode;
    }

    @Override
    @JsonView(View.List.class)
    @Transient
    public String getOrgName() {
        if (super.orgName == null) {
            super.orgName = this.org != null ? this.org.getOrgName() : null;
        }
        return super.orgName;
    }

    @Override
    public boolean equals(Object o) {
        return super.equals(o);
    }

    @Override
    public int hashCode() {
        return super.hashCode();
    }
}
