package com.xforceplus.entity;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonView;
import io.geewit.core.jackson.view.View;
import io.geewit.data.jpa.essential.id.IDGenerators;
import org.hibernate.annotations.DynamicInsert;
import org.hibernate.annotations.DynamicUpdate;
import org.hibernate.annotations.GenericGenerator;

import javax.persistence.*;
import java.io.Serializable;
import java.util.Objects;


@JsonIgnoreProperties(value = {"hibernateLazyInitializer", "handler", "fieldHandler"}, ignoreUnknown = true)
@NamedEntityGraphs({
        @NamedEntityGraph(name = "SettleFlowPackage.graph",
                attributeNodes = {//attributeNodes 来定义需要懒加载的属性
                        @NamedAttributeNode("servicePackage")
                }
        )})
@DynamicInsert
@DynamicUpdate
@Entity
@Table(name = "settle_flow_package_rel")
public class SettleFlowPackage implements Serializable {
    @JsonView(View.class)
    private Long id;

    @JsonView(View.class)
    private Long flowId;

    @JsonView(View.class)
    private Long packageId;

    @JsonView(View.class)
    private ServicePackage servicePackage;

    @JsonIgnore
    private SettleFlow flow;

    @Id
    @Column(name = "id")
    @GeneratedValue(strategy = GenerationType.TABLE, generator = "SnowflakeGenerator")
    @GenericGenerator(name = "SnowflakeGenerator", strategy = IDGenerators.SnowflakeGenerator)
    public Long getId() {
        return id;
    }


    @Basic
    @Column(name = "flow_id")
    public Long getFlowId() {
        return (flowId != null && flowId > 0) ? flowId : null;
    }

    @Basic
    @Column(name = "package_id")
    public Long getPackageId() {
        return (packageId != null && packageId > 0) ? packageId : null;
    }

    @ManyToOne(fetch = FetchType.LAZY)
    @JoinColumn(name = "flow_id", insertable = false, updatable = false, foreignKey = @ForeignKey(value = ConstraintMode.NO_CONSTRAINT))
    public SettleFlow getFlow() {
        return flow;
    }

    public void setFlow(SettleFlow flow) {
        this.flow = flow;
    }

    @ManyToOne(fetch = FetchType.LAZY)
    @JoinColumn(name = "package_id", insertable = false, updatable = false, foreignKey = @ForeignKey(value = ConstraintMode.NO_CONSTRAINT))
    public ServicePackage getServicePackage() {
        return servicePackage;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public void setFlowId(Long flowId) {
        this.flowId = flowId;
    }

    public void setPackageId(Long packageId) {
        this.packageId = packageId;
    }

    public void setServicePackage(ServicePackage servicePackage) {
        this.servicePackage = servicePackage;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        SettleFlowPackage that = (SettleFlowPackage) o;
        return Objects.equals(flowId, that.flowId) && Objects.equals(packageId, that.packageId);
    }

    @Override
    public int hashCode() {
        return Objects.hash(id);
    }
}
