package com.xforceplus.entity;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.xforceplus.domain.sso.SsoConfDto;
import com.xforceplus.jpa.listener.SsoConfListener;
import io.geewit.data.jpa.essential.id.IDGenerators;
import org.hibernate.annotations.DynamicInsert;
import org.hibernate.annotations.DynamicUpdate;
import org.hibernate.annotations.GenericGenerator;

import javax.persistence.*;
import java.io.Serializable;
import java.util.Date;

@JsonIgnoreProperties(value = {"hibernateLazyInitializer", "handler", "fieldHandler"}, ignoreUnknown = true)
@DynamicInsert
@DynamicUpdate
@Entity
@Table(name = "sys_sso_conf")
@EntityListeners({SsoConfListener.class})
public class SsoConf extends SsoConfDto<SsoSaml, SsoAuth2, SsoJwt> implements Serializable {



    @Override
    @Id
    @Column(name = "id")
    @GeneratedValue(strategy = GenerationType.TABLE, generator = "SnowflakeGenerator")
    @GenericGenerator(name = "SnowflakeGenerator", strategy = IDGenerators.SnowflakeGenerator)
    public long getId() {
        return id;
    }

    @Override
    public void setId(long id) {
        this.id = id;
    }

    @Override
    @Basic
    @Column(name = "tenant_id")
    public long getTenantId() {
        return tenantId;
    }

    @Override
    public void setTenantId(long tenantId) {
        this.tenantId = tenantId;
    }

    @Override
    @Basic
    @Column(name = "tenant_code")
    public String getTenantCode() {
        return tenantCode;
    }

    @Override
    public void setTenantCode(String tenantCode) {
        this.tenantCode = tenantCode;
    }

    @Override
    @Basic
    @Column(name = "protocol_type")
    public String getProtocolType() {
        return protocolType;
    }

    @Override
    public void setProtocolType(String protocolType) {
        this.protocolType = protocolType;
    }

    @Override
    @Basic
    @Column(name = "status")
    public boolean isStatus() {
        return status;
    }

    @Override
    public void setStatus(boolean status) {
        this.status = status;
    }

    
    @Override
    @Basic
    @Column(name = "sso_url")
    public String getSsoUrl() {
        return ssoUrl;
    }

    @Override
    public void setSsoUrl(String ssoUrl) {
        this.ssoUrl = ssoUrl;
    }
    @Override
    @Basic
    @Column(name = "update_user_id")
    public String getUpdateUserId() {
        return updateUserId;
    }

    @Override
    public void setUpdateUserId(String updateUserId) {
        this.updateUserId = updateUserId;
    }

    @Override
    @Basic
    @Column(name = "update_user_name")
    public String getUpdateUserName() {
        return updateUserName;
    }

    @Override
    public void setUpdateUserName(String updateUserName) {
        this.updateUserName = updateUserName;
    }

    @Override
    @Temporal(TemporalType.TIMESTAMP)
    @Column(name = "update_time")
    public Date getUpdateTime() {
        return updateTime;
    }

    @Override
    public void setUpdateTime(Date updateTime) {
        this.updateTime = updateTime;
    }

    @Override
    @Basic
    @Column(name = "create_user_id")
    public String getCreateUserId() {
        return createUserId;
    }

    @Override
    public void setCreateUserId(String createUserId) {
        this.createUserId = createUserId;
    }

    @Override
    @Temporal(TemporalType.TIMESTAMP)
    @Column(name = "create_time")
    public Date getCreateTime() {
        return createTime;
    }

    @Override
    public void setCreateTime(Date createTime) {
        this.createTime = createTime;
    }

    @Override
    @OneToOne(mappedBy="ssoConf")
    public SsoSaml getSsoSaml() {
        return ssoSaml;
    }

    @Override
    public void setSsoSaml(SsoSaml ssoSaml) {
         this.ssoSaml = ssoSaml;
    }

    @Override
    @OneToOne(mappedBy="ssoConf")
    public SsoAuth2 getSsoAuth2() {
        return ssoAuth2;
    }

    @Override
    public void setSsoAuth2(SsoAuth2 ssoAuth2) {
        this.ssoAuth2 = ssoAuth2;
    }

    @Override
    @OneToOne(mappedBy="ssoConf")
    public SsoJwt getSsoJwt() {
        return ssoJwt;
    }

    @Override
    public void setSsoJwt(SsoJwt ssoJwt) {
        this.ssoJwt = ssoJwt;
    }
}
