package com.xforceplus.entity;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.xforceplus.domain.tenant.TenantExtensionDto;
import com.xforceplus.jpa.listener.TenantExtensionListener;
import io.geewit.data.jpa.essential.id.IDGenerators;
import org.hibernate.annotations.DynamicInsert;
import org.hibernate.annotations.DynamicUpdate;
import org.hibernate.annotations.GenericGenerator;

import javax.persistence.*;
import java.io.Serializable;
import java.util.Date;

@JsonIgnoreProperties(value = {"hibernateLazyInitializer", "handler", "fieldHandler"}, ignoreUnknown = true)
@EntityListeners({TenantExtensionListener.class})
@DynamicInsert
@DynamicUpdate
@Entity
@Table(name = "tenant_extension")
public class TenantExtension extends TenantExtensionDto implements Serializable {

    private Long tenantExtensionId;

    @Id
    @Column(name = "tenant_extension_id")
    @GeneratedValue(strategy = GenerationType.TABLE, generator = "SnowflakeGenerator")
    @GenericGenerator(name = "SnowflakeGenerator", strategy = IDGenerators.SnowflakeGenerator)
    public Long getTenantExtensionId() {
        return tenantExtensionId;
    }

    public void setTenantExtensionId(Long tenantExtensionId) {
        this.tenantExtensionId = tenantExtensionId;
    }


    @Override
    @Basic
    @Column(name = "tenant_id", nullable = false)
    public Long getTenantId() {
        return super.tenantId;
    }

    @Override
    @Basic
    @Column(name = "extension_key", nullable = false)
    public String getExtensionKey() {
        return super.extensionKey;
    }

    @Override
    @Basic
    @Column(name = "extension_value", nullable = false)
    public String getExtensionValue() {
        return super.extensionValue;
    }

    @Override
    @Basic
    @Column(name = "status", nullable = false)
    public Integer getStatus() {
        return status;
    }

    @Override
    @Temporal(TemporalType.TIMESTAMP)
    @Column(name = "create_time")
    public Date getCreateTime() {
        return createTime;
    }

    @Override
    @Basic
    @Column(name = "update_time")
    public Date getUpdateTime() {
        return updateTime;
    }

    @Override
    public boolean equals(Object o) {
        return super.equals(o);
    }

    @Override
    public int hashCode() {
        return super.hashCode();
    }
}
