package com.xforceplus.entity;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.xforceplus.domain.account.WechatInfoDto;
import io.geewit.data.jpa.essential.id.IDGenerators;
import org.hibernate.annotations.DynamicInsert;
import org.hibernate.annotations.DynamicUpdate;
import org.hibernate.annotations.GenericGenerator;

import javax.persistence.*;
import java.io.Serializable;
import java.util.Date;

@JsonIgnoreProperties(value = {"hibernateLazyInitializer", "handler", "fieldHandler"}, ignoreUnknown = true)
@DynamicInsert
@DynamicUpdate
@Entity
@Table(name = "sys_wechat_info")
public class WechatInfo extends WechatInfoDto implements Serializable {

    @Override
    @Id
    @Column(name = "id", nullable = false)
    @GeneratedValue(strategy = GenerationType.TABLE, generator = "SnowflakeGenerator")
    @GenericGenerator(name = "SnowflakeGenerator", strategy = IDGenerators.SnowflakeGenerator)
    public Long getId() {
        return id;
    }

    @Override
    @Basic
    @Column(name = "access_token")
    public String getAccessToken() {
        return super.getAccessToken();
    }

    @Override
    @Basic
    @Column(name = "token_time")
    public Date getTokenTime() {
        return super.getTokenTime();
    }

    @Override
    @Basic
    @Column(name = "token_period")
    public Integer getTokenPeriod() {
        return super.getTokenPeriod();
    }

    @Override
    @Basic
    @Column(name = "jsapi_ticket")
    public String getJsapiTicket() {
        return super.getJsapiTicket();
    }

    @Override
    @Basic
    @Column(name = "ticket_time")
    public Date getTicketTime() {
        return super.getTicketTime();
    }

    @Override
    @Basic
    @Column(name = "ticket_period")
    public Integer getTicketPeriod() {
        return super.getTicketPeriod();
    }

    @Override
    @Basic
    @Column(name = "status", nullable = false)
    public Integer getStatus() {
        return super.getStatus();
    }

    @Override
    @Temporal(TemporalType.TIMESTAMP)
    @Column(name = "create_time")
    public Date getCreateTime() {
        return super.getCreateTime();
    }

    @Override
    @Temporal(TemporalType.TIMESTAMP)
    @Column(name = "update_time")
    public Date getUpdateTime() {
        return super.getUpdateTime();
    }

}
