package com.xforceplus.jpa.listener;

import com.xforceplus.entity.Client;
import io.geewit.utils.uuid.UUID;
import org.apache.commons.lang3.StringUtils;

import javax.persistence.PrePersist;
import java.util.Calendar;
import java.util.Date;

/**
 * 创建时间, 更新时间, 删除标志自动保存/更新的JPA 监听器
 *
 * @author geewit
 * @since 2019-10-29
 */
public class ClientPersistenceListener {
    @PrePersist
    public void prePersist(Client client) {
        Date now = Calendar.getInstance().getTime();
        if (client.getCreateTime() == null) {
            client.setCreateTime(now);
        }
        if (StringUtils.isEmpty(client.getSecret())) {
            client.setSecret(UUID.randomUUID().toString());
        }
    }

//    @PreUpdate
//    public void preUpdate(Route route) {
//        Integer createrId = listenedEntity.getUpdaterId();
//    }
}