package com.xforceplus.jpa.listener;


import com.xforceplus.entity.Role;
import org.apache.commons.lang3.StringUtils;

import javax.persistence.PrePersist;
import javax.persistence.PreUpdate;


/**
 * 自动保存/更新的JPA 监听器
 *
 * @author geewit
 * @since 2020-01-15
 */
public class RoleListener extends OperatorListener<Role> {
    @PrePersist
    public void prePersist(Role entity) {
        if (entity.getStatus() == null) {
            entity.setStatus(1);
        }
        if (StringUtils.isBlank(entity.getRoleDesc())) {
            entity.setRoleDesc(entity.getName());
        }
        super.beforeInsert(entity);
    }

    @PreUpdate
    public void preUpdate(Role entity) {
        if (StringUtils.isBlank(entity.getRoleDesc())) {
            entity.setRoleDesc(entity.getName());
        }
        super.beforeUpdate(entity);
    }
}