package com.xforceplus.query;

import com.xforceplus.api.model.OrgModel;
import com.xforceplus.entity.*;
import com.xforceplus.tenant.security.core.domain.OrgType;
import org.apache.commons.lang3.StringUtils;
import org.springframework.data.jpa.domain.Specification;
import org.springframework.util.CollectionUtils;

import javax.persistence.Tuple;
import javax.persistence.criteria.*;
import java.util.ArrayList;
import java.util.List;

/**
 * @author geewit
 */
@SuppressWarnings("all")
public class OrgQueryHelper {
    public static Specification<OrgStruct> querySpecification(OrgModel.Request.Query query) {
        Specification<OrgStruct> specification = (Specification<OrgStruct>) (root, criteriaQuery, builder) -> {
            return toPredicate(query, root, criteriaQuery, builder);
        };
        return specification;
    }

    public static Predicate queryTuplePredicate(OrgModel.Request.Query query, Root<OrgStruct> root, CriteriaQuery<Tuple> criteriaQuery, CriteriaBuilder builder) {
        return toPredicate(query, root, criteriaQuery, builder);
    }


    public static Predicate queryCountPredicate(OrgModel.Request.Query query, Root<OrgStruct> root, CriteriaQuery<Long> criteriaQuery, CriteriaBuilder builder) {
        return toPredicate(query, root, criteriaQuery, builder);
    }

    private static <T> Predicate toPredicate(OrgModel.Request.Query query, Root<OrgStruct> root, CriteriaQuery<T> criteriaQuery, CriteriaBuilder builder) {
        List<Predicate> predicates = new ArrayList<>();
        Class<T> resultType = criteriaQuery.getResultType();
        boolean isCount = resultType.isAssignableFrom(Long.class);
        boolean joinTable = false;
        Join<OrgStruct, Company> joinCompany = null;
        Join<OrgStruct, Tenant> joinTenant = null;

        if ((query.getUserId() != null && query.getUserId() > 0) || (query.getAccountId() != null && query.getAccountId() > 0)) {
            ListJoin<OrgStruct, OrgUserRel> joinOrgUserRel = root.joinList("orgUserRels", JoinType.LEFT);
            if (query.getUserId() != null && query.getUserId() > 0) {
                boolean withExtraPredicates = false;
                //region
                if ((query.getUserBoundFront() != null && query.getUserBoundFront()) || (query.getUserUnBound() != null && query.getUserUnBound()) || (query.getWithUserBoundFlag() != null && query.getWithUserBoundFlag())) {
                    joinOrgUserRel.on(builder.equal(joinOrgUserRel.<Long>get("userId"), query.getUserId()));
                    if (resultType.isAssignableFrom(Tuple.class)) {
                        joinCompany = root.join("company", JoinType.LEFT);
                        joinTenant = root.join("tenant", JoinType.LEFT);
                        if ((query.getUserBoundFront() != null && query.getUserBoundFront()) || (query.getWithUserBoundFlag() != null && query.getWithUserBoundFlag())) {
                            Expression<Long> countExpression = builder.count(joinOrgUserRel.<Long>get("id"));
                            if (query.getUserBoundFront() != null && query.getUserBoundFront()) {
                                criteriaQuery = criteriaQuery.multiselect(root.alias("org"), joinCompany.alias("company"), joinTenant.alias("tenant"));
                                criteriaQuery.orderBy(builder.desc(countExpression));
                            } else if (query.getWithUserBoundFlag() != null && query.getWithUserBoundFlag()) {
                                criteriaQuery = criteriaQuery.multiselect(root.alias("org"), joinCompany.alias("company"), joinTenant.alias("tenant"), countExpression.alias("userBound"));
                            }
                        }
                    }
                    if (query.getUserUnBound() != null && query.getUserUnBound()) {
                        predicates.add(builder.isNull(joinOrgUserRel.<Long>get("id")));
                    }
                    withExtraPredicates = true;
                }
                if(!withExtraPredicates) {
                    predicates.add(builder.equal(joinOrgUserRel.<Long>get("userId"), query.getUserId()));
                }
            }
            if (query.getAccountId() != null && query.getAccountId() > 0) {
                Join<OrgUserRel, User> joinUser = joinOrgUserRel.join("user", JoinType.LEFT);
                predicates.add(builder.equal(joinUser.<Long>get("accountId"), query.getAccountId()));
                if (query.getStatus() != null && query.getStatus() == 1) {
                    predicates.add(builder.equal(joinUser.get("status"), 1));
                }
            }
            joinTable = true;
        }
        if (StringUtils.isNotBlank(query.getCompanyNo())) {
            SetJoin<OrgStruct, String> joinCompanyNo = root.joinSet("companyNos", JoinType.LEFT);
            if (query.getCompanyNo().contains(",")) {
                String[] companyNos = query.getCompanyNo().split(",");
                CriteriaBuilder.In<String> in = builder.in(joinCompanyNo);
                for (String code : companyNos) {
                    in.value(code);
                }
                predicates.add(in);
            } else {
                predicates.add(builder.equal(joinCompanyNo, query.getCompanyNo()));
            }
            joinTable = true;
        }

        if (query.getOrgId() != null && query.getOrgId() > 0) {
            predicates.add(builder.equal(root.<Long>get("orgId"), query.getOrgId()));
        }
        if (query.getTenantId() != null && query.getTenantId() > 0) {
            predicates.add(builder.equal(root.<Long>get("tenantId"), query.getTenantId()));
        }
        if (StringUtils.isNotBlank(query.getTenantCode()) || StringUtils.isNotBlank(query.getTenantName()) || StringUtils.isNotBlank(query.getTenantNameEqual())) {
            if (joinTenant == null) {
                joinTenant = root.join("tenant", JoinType.LEFT);
            }
            if (StringUtils.isNotBlank(query.getTenantCode())) {
                predicates.add(builder.equal(joinTenant.<String>get("tenantCode"), query.getTenantCode()));
            }
            if (StringUtils.isNotBlank(query.getTenantNameEqual())) {
                predicates.add(builder.equal(joinTenant.<String>get("tenantName"), query.getTenantNameEqual()));
            }

            if (StringUtils.isNotBlank(query.getTenantName())) {
                predicates.add(builder.like(joinTenant.get("tenantName"), query.getTenantName() + "%"));
            }
        }
        if (query.getCompanyId() != null && query.getCompanyId() > 0) {
            predicates.add(builder.equal(root.<Long>get("companyId"), query.getCompanyId()));
        }
        if (StringUtils.isNotBlank(query.getOrgCode())) {
            if (query.getOrgCode().contains(",")) {
                String[] orgCodes = query.getOrgCode().split(",");
                CriteriaBuilder.In<String> in = builder.in(root.get("orgCode"));
                for (String code : orgCodes) {
                    in.value(code);
                }
                predicates.add(in);
            } else {
                predicates.add(builder.equal(root.<String>get("orgCode"), query.getOrgCode()));
            }
        }
        //
        if (query.getOrgType() != null) {
            OrgType orgType;
            try {
                int orgTypeVal = Integer.parseInt(query.getOrgType());
                orgType = OrgType.values()[orgTypeVal];
            } catch (Exception e) {
                try {
                    orgType = OrgType.valueOf(query.getOrgType());
                } catch (Exception e1) {
                    orgType = null;
                }
            }
            if(orgType != null) {
                predicates.add(builder.equal(root.<OrgType>get("orgType"), orgType));
            }
        }
        //不需要根节点
        if (query.getWithNoRootOrg() != null && query.getWithNoRootOrg().equals(Boolean.TRUE)) {
            predicates.add(builder.notEqual((root.<OrgType>get("orgType")), OrgType.GROUP));
        }
        if (StringUtils.isNotBlank(query.getOrgNameEqual())) {
            predicates.add(builder.equal(root.<String>get("orgName"), query.getOrgNameEqual()));
        } else if (StringUtils.isNotBlank(query.getOrgName())) {
            if (query.getOrgName().contains(",")) {
                String[] names = query.getOrgName().split(",");
                CriteriaBuilder.In<String> in = builder.in(root.get("orgName"));
                for (String name : names) {
                    in.value(name);
                }
                predicates.add(in);
            } else {
                predicates.add(builder.like(root.<String>get("orgName"), query.getOrgName() + "%"));
            }
        }
        if (StringUtils.isNotBlank(query.getParentIds())) {
            predicates.add(builder.like(root.get("parentIds"), query.getParentIds() + "%"));
        }
        if (query.getStatus() != null) {
            predicates.add(builder.equal(root.<Integer>get("status"), query.getStatus()));
        }
        if (StringUtils.isNotBlank(query.getCompanyCode()) || StringUtils.isNotBlank(query.getCompanyName()) || StringUtils.isNotBlank(query.getTaxNum())) {
            if (joinCompany == null) {
                joinCompany = root.join("company", JoinType.LEFT);
            }
            if (StringUtils.isNotBlank(query.getCompanyCode())) {
                predicates.add(builder.equal(joinCompany.<String>get("companyCode"), query.getCompanyCode()));
            }
            if (StringUtils.isNotBlank(query.getCompanyName())) {
                predicates.add(builder.like(joinCompany.get("companyName"), query.getCompanyName() + "%"));
            }
            if (StringUtils.isNotBlank(query.getTaxNum())) {
                if (query.getTaxNum().contains(",")) {
                    String[] taxNums = query.getTaxNum().split(",");
                    CriteriaBuilder.In<String> in = builder.in(joinCompany.get("taxNum"));
                    for (String name : taxNums) {
                        in.value(name);
                    }
                    predicates.add(in);
                } else {
                    predicates.add(builder.equal(joinCompany.<String>get("taxNum"), query.getTaxNum()));
                }
            }
            if (query.getStatus() != null && query.getStatus() == 1) {
                predicates.add(builder.equal(joinCompany.get("status"), 1));
            }
        }
        if (query.getRootOrg() != null && query.getRootOrg()) {
            predicates.add(builder.or(builder.isNull(root.<Long>get("parentId")), builder.equal(root.<Long>get("parentId"), 0)));
        } else {
            if (query.getParentId() != null && query.getParentId() > 0) {
                predicates.add(builder.equal(root.<Long>get("parentId"), query.getParentId()));
            }
        }
        if (!CollectionUtils.isEmpty(query.getIds())) {
            CriteriaBuilder.In<Long> in = builder.in(root.get("orgId"));
            for (Long id : query.getIds()) {
                in.value(id);
            }
            predicates.add(in);
        }
        if (predicates.isEmpty()) {
            predicates.add(builder.equal(root.<Integer>get("status"), 1));
        }
        criteriaQuery.where(predicates.stream().toArray(Predicate[]::new));
        if (joinTable) {
            if (isCount) {
                criteriaQuery.distinct(true);
            } else {
                criteriaQuery.groupBy(root.<Long>get("orgId"));
            }
        }
        Predicate predicate = criteriaQuery.getRestriction();
        return predicate;
    }

    public static Specification<OrgStruct> queryOneSpecification(OrgModel.Request.Query query) {
        Specification<OrgStruct> specification = (Specification<OrgStruct>) (root, criteriaQuery, builder) -> {
            List<Predicate> predicates = new ArrayList<>();
            if (query.getOrgId() != null && query.getOrgId() > 0) {
                predicates.add(builder.equal(root.<Long>get("orgId"), query.getOrgId()));
            }
            if (query.getTenantId() != null && query.getTenantId() > 0) {
                predicates.add(builder.equal(root.<Long>get("tenantId"), query.getTenantId()));
                if (StringUtils.isNotBlank(query.getOrgCode()) || StringUtils.isNotBlank(query.getOrgName()) || (query.getCompanyId() != null && query.getCompanyId() > 0)) {

                    if (StringUtils.isNotBlank(query.getOrgCode())) {
                        predicates.add(builder.equal(root.<String>get("orgCode"), query.getOrgCode()));
                    }
                    if (StringUtils.isNotBlank(query.getOrgName())) {
                        predicates.add(builder.equal(root.<String>get("orgName"), query.getOrgName()));
                    }
                    if (query.getCompanyId() != null && query.getCompanyId() > 0) {
                        predicates.add(builder.equal(root.<Long>get("companyId"), query.getCompanyId()));
                    }
                }
            }

            if (predicates.isEmpty()) {
                throw new IllegalArgumentException("缺少查询参数");
            } else {
                criteriaQuery.where(predicates.stream().toArray(Predicate[]::new));
            }
            return criteriaQuery.getRestriction();
        };
        return specification;
    }
}
