package com.xforceplus.query;

import com.xforceplus.api.model.OrgVirtualModel;
import com.xforceplus.entity.OrgVirtual;
import com.xforceplus.entity.OrgVirtualNode;
import org.apache.commons.lang3.StringUtils;
import org.springframework.data.jpa.domain.Specification;

import javax.persistence.criteria.JoinType;
import javax.persistence.criteria.ListJoin;
import javax.persistence.criteria.Predicate;
import java.util.ArrayList;
import java.util.List;

/**
 * 版权：    上海云砺信息科技有限公司
 * 创建者:   duanhy
 * 创建时间: 2020/12/22 11:14
 * 功能描述:
 * 修改历史:
 */
@SuppressWarnings("all")
public class OrgVirtualQueryHelper {
    public static Specification<OrgVirtual> querySpecification(OrgVirtualModel.Request.Query query) {
        Specification<OrgVirtual> specification = (Specification<OrgVirtual>) (root, criteriaQuery, builder) -> {
            List<Predicate> predicates = new ArrayList<>();
            predicates.add(builder.equal(root.<Long>get("tenantId"), query.getTenantId()));

            if(null != query.getTypeId()){
                ListJoin<OrgVirtual, OrgVirtualNode> joinTreeRels = root.joinList("orgVirtualNodes", JoinType.LEFT);
                predicates.add(builder.equal(joinTreeRels.<Long>get("nodeTypeId"), query.getTypeId()));
            }

            if (StringUtils.isNotBlank(query.getOrgName())) {
                predicates.add(builder.like(root.<String>get("orgName"), query.getOrgName() + "%"));
            }
            if (StringUtils.isNotBlank(query.getOrgCode())) {
                predicates.add(builder.like(root.<String>get("orgCode"), query.getOrgCode() + "%"));
            }
            if (StringUtils.isNotBlank(query.getShortName())) {
                predicates.add(builder.like(root.<String>get("shortName"), query.getShortName() + "%"));
            }
            if (query.getStatus() != null) {
                predicates.add(builder.equal(root.<Integer>get("status"), query.getStatus()));
            }
            if (!predicates.isEmpty()) {
                criteriaQuery.where(predicates.stream().toArray(Predicate[]::new));
            }
            return criteriaQuery.getRestriction();
        };
        return specification;
    }

}
