package com.xforceplus.query;

import com.xforceplus.api.model.OrgVirtualNodeModel;
import com.xforceplus.api.utils.Separator;
import com.xforceplus.entity.OrgVirtual;
import com.xforceplus.entity.OrgVirtualNode;
import org.apache.commons.lang3.StringUtils;
import org.springframework.data.jpa.domain.Specification;

import javax.persistence.criteria.Join;
import javax.persistence.criteria.JoinType;
import javax.persistence.criteria.Predicate;
import java.util.ArrayList;
import java.util.List;

/**
 * 版权：    上海云砺信息科技有限公司
 * 创建者:   duanhy
 * 创建时间: 2020/12/22 11:14
 * 功能描述:
 * 修改历史:
 */
@SuppressWarnings("all")
public class OrgVirtualTreeQueryHelper {
    public static Specification<OrgVirtualNode> querySpecification(OrgVirtualNodeModel.Request.Query query) {
        Specification<OrgVirtualNode> specification = (Specification<OrgVirtualNode>) (root, criteriaQuery, builder) -> {
            List<Predicate> predicates = new ArrayList<>();
            predicates.add(builder.equal(root.<Long>get("tenantId"), query.getTenantId()));
            predicates.add(builder.equal(root.<Long>get("nodeTypeId"), query.getTypeId()));
            if (null != query.getOrgVirtualId()) {
                predicates.add(builder.equal(root.<Long>get("orgVirtualId"), query.getOrgVirtualId()));
            }
            if (StringUtils.isNotBlank(query.getParentIds())) {
                predicates.add(builder.like(root.<String>get("parentIds"), query.getParentIds() + Separator.LIKE));
            }

            Join<OrgVirtualNode, OrgVirtual> joinUser = root.join("orgVirtual", JoinType.LEFT);
            if (StringUtils.isNotBlank(query.getOrgCode())) {
                predicates.add(builder.and(
                        builder.like(joinUser.get("orgCode"), query.getOrgCode() + "%")
                ));
            }
            if (StringUtils.isNotBlank(query.getOrgName())) {
                predicates.add(builder.and(
                        builder.like(joinUser.get("orgName"), query.getOrgName() + "%")
                ));
            }

            if (!predicates.isEmpty()) {
                criteriaQuery.where(predicates.stream().toArray(Predicate[]::new));
            }
            return criteriaQuery.getRestriction();
        };
        return specification;
    }

}
