package com.xforceplus.query;

import com.xforceplus.api.model.ResourceModel.Request.Query;
import com.xforceplus.entity.*;
import org.apache.commons.lang3.StringUtils;
import org.springframework.data.jpa.domain.Specification;
import org.springframework.util.CollectionUtils;

import javax.persistence.criteria.Join;
import javax.persistence.criteria.JoinType;
import javax.persistence.criteria.ListJoin;
import javax.persistence.criteria.Predicate;
import java.util.ArrayList;
import java.util.List;

@SuppressWarnings("all")
public class ResourceQueryHelper {
    public static Specification<Resource> querySpecification(Query query) {
        Specification<Resource> specification = (Specification<Resource>) (root, criteriaQuery, builder) -> {
            List<Predicate> predicates = new ArrayList<>();
            boolean joinTable = false;
            if ((query.getResourcesetId() != null && query.getResourcesetId() > 0) || (query.getTenantId() != null && query.getTenantId() > 0) || (query.getRoleId() != null && query.getRoleId() > 0) || (query.getUserId() != null && query.getUserId() > 0) || !CollectionUtils.isEmpty(query.getPackageIds())) {
                Join<Resource, Resourceset> joinResourceset = root.joinList("resourcesetResourceRels", JoinType.LEFT)
                        .join("resourceset", JoinType.LEFT);
                if (query.getStatus() != null && query.getStatus() == 1) {
                    predicates.add(builder.equal(joinResourceset.get("status"), 1));
                }
                if (query.getResourcesetId() != null && query.getResourcesetId() > 0) {
                    predicates.add(builder.equal(joinResourceset.<Long>get("resourcesetId"), query.getResourcesetId()));
                } else if (!CollectionUtils.isEmpty(query.getResourcesetIds())) {
                    predicates.add(joinResourceset.<Long>get("resourcesetId").in(query.getResourcesetIds()));
                }
                if ((query.getTenantId() != null && query.getTenantId() > 0) || (query.getCompanyId() != null && query.getCompanyId() > 0) || !CollectionUtils.isEmpty(query.getPackageIds())) {
                    ListJoin<Resourceset, ServiceResourcesetRel> joinServiceResourcesetRel = joinResourceset
                            .joinList("serviceResourcesetRels", JoinType.LEFT);
                    Join<ServiceResourcesetRel, ServicePackage> joinServicePackage = joinServiceResourcesetRel
                            .join("servicePackage", JoinType.LEFT);
                    if (query.getStatus() != null && query.getStatus() == 1) {
                        predicates.add(builder.equal(joinServicePackage.get("status"), 1));
                    }
                    if (!CollectionUtils.isEmpty(query.getPackageIds())) {
                        predicates.add(joinServicePackage.get("servicePackageId").in(query.getPackageIds()));
                    }
                    ListJoin<ServicePackage, CompanyServiceRel> joinCompanyServiceRel = joinServicePackage
                            .joinList("companyServiceRels", JoinType.LEFT);
                    if (query.getTenantId() != null && query.getTenantId() > 0) {
                        predicates.add(builder.equal(joinCompanyServiceRel.<Long>get("tenantId"), query.getTenantId()));
                    }
                    if (query.getCompanyId() != null && query.getCompanyId() > 0) {
                        predicates.add(builder.equal(joinCompanyServiceRel.<Long>get("companyId"), query.getCompanyId()));
                    }
                }
                if ((query.getRoleId() != null && query.getRoleId() > 0) || (query.getUserId() != null && query.getUserId() > 0)) {
                    ListJoin<Resourceset, RoleResourcesetRel> joinRoleResourcesetRels = joinResourceset.joinList("roleResourcesetRels", JoinType.LEFT);
                    if (query.getRoleId() != null && query.getRoleId() > 0) {
                        predicates.add(builder.equal(joinRoleResourcesetRels.<Long>get("roleId"), query.getRoleId()));
                    }
                    if (query.getUserId() != null && query.getUserId() > 0) {
                        Join<RoleResourcesetRel, Role> joinRole = joinRoleResourcesetRels.join("role", JoinType.LEFT);
                        if (query.getStatus() != null && query.getStatus() == 1) {
                            predicates.add(builder.equal(joinRole.get("status"), 1));
                        }
                        ListJoin<Role, RoleUserRel> joinRoleUserRels = joinRole.joinList("roleUserRels", JoinType.LEFT);
                        predicates.add(builder.equal(joinRoleUserRels.<Long>get("userId"), query.getUserId()));
                    }
                }
                joinTable = true;
            }

            if ((query.getServiceApiId() != null && query.getServiceApiId() > 0) || StringUtils.isNotBlank(query.getServiceApiName())) {
                ListJoin<Resource, ResourceApiRel> joinResourceApiRels = root.joinList("resourceApiRels", JoinType.LEFT);
                if (query.getServiceApiId() != null && query.getServiceApiId() > 0) {
                    predicates.add(builder.equal(joinResourceApiRels.<Long>get("serviceApiId"), query.getServiceApiId()));
                }
                if (StringUtils.isNotBlank(query.getServiceApiName())) {
                    Join<ResourceApiRel, ServiceApi> joinServiceApi = joinResourceApiRels.join("serviceApi", JoinType.LEFT);
                    predicates.add(builder.like(joinServiceApi.get("serviceApiName"), query.getServiceApiName() + "%"));
                    if (query.getStatus() != null && query.getStatus() == 1) {
                        predicates.add(builder.equal(joinServiceApi.get("status"), 1));
                    }
                }
                joinTable = true;
            }

            if (query.getResourceId() != null && query.getResourceId() > 0) {
                predicates.add(builder.equal(root.<Long>get("resourceId"), query.getResourceId()));
            } else if (!CollectionUtils.isEmpty(query.getResourceIds())) {
                //添加ResourceIds 导出功能
                predicates.add(root.<Long>get("resourceId").in(query.getResourceIds()));
            }
            if (StringUtils.isNotBlank(query.getResourceName())) {
                predicates.add(builder.like(root.get("resourceName"), query.getResourceName() + "%"));
            }
            if (query.getAppId() != null && query.getAppId() > 0) {
                predicates.add(builder.equal(root.<Long>get("appId"), query.getAppId()));
            }
            if (StringUtils.isNotBlank(query.getResourceCode())) {
                predicates.add(builder.equal(root.<String>get("resourceCode"), query.getResourceCode()));
            }
            if (StringUtils.isNotBlank(query.getResourceCodeLike())) {
                predicates.add(builder.like(root.get("resourceCode"), query.getResourceCodeLike() + "%"));
            }
            if (query.getStatus() != null) {
                predicates.add(builder.equal(root.<Integer>get("status"), query.getStatus()));
            }
            if (query.getIsServicePackage() != null) {
                predicates.add(builder.equal(root.<Boolean>get("isServicePackage"), query.getIsServicePackage()));
            }

            boolean isFlat = query.isFlat();
            if (isFlat) {
                if (query.getParentId() != null && query.getParentId() > 0) {
                    predicates.add(builder.equal(root.<Long>get("parentId"), query.getParentId()));
                }
            } else {
                predicates.add(builder.or(builder.isNull(root.<Long>get("parentId")), builder.equal(root.<Long>get("parentId"), 0)));
            }
            if (!predicates.isEmpty()) {
                criteriaQuery.where(predicates.stream().toArray(Predicate[]::new));
            }
            if (joinTable) {
                if (criteriaQuery.getResultType().isAssignableFrom(Long.class)) {
                    criteriaQuery.distinct(true);
                    return criteriaQuery.getRestriction();
                } else {
                    criteriaQuery.groupBy(root.<Long>get("resourceId"));
                    return criteriaQuery.getGroupRestriction();
                }
            } else {
                return criteriaQuery.getRestriction();
            }
        };
        return specification;
    }

    public static Specification<Resource> queryOneSpecification(Query query) {
        Specification<Resource> specification = (Specification<Resource>) (root, criteriaQuery, builder) -> {
            List<Predicate> predicates = new ArrayList<>();
            if (query.getResourceId() != null && query.getResourceId() > 0) {
                predicates.add(builder.equal(root.<Long>get("resourceId"), query.getResourceId()));
            } else {
                if (StringUtils.isNotBlank(query.getResourceName())) {
                    predicates.add(builder.equal(root.<String>get("resourceName"), query.getResourceName()));
                }
                if (query.getAppId() != null && query.getAppId() > 0) {
                    predicates.add(builder.equal(root.<Long>get("appId"), query.getAppId()));
                }
            }
            if (!predicates.isEmpty()) {
                criteriaQuery.where(predicates.stream().toArray(Predicate[]::new));
            }
            return criteriaQuery.getRestriction();
        };
        return specification;
    }
}
