package com.xforceplus.query;

import com.xforceplus.api.model.SsoConfModel.Request.Query;
import com.xforceplus.entity.SsoConf;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.data.jpa.domain.Specification;

import javax.persistence.criteria.Predicate;
import java.util.ArrayList;
import java.util.List;

/**
 * @author geewit
 */
@SuppressWarnings("all")
public class SsoConfHelper {
    private final static Logger logger = LoggerFactory.getLogger(SsoConfHelper.class);

    /**
     * 构建查询 Specification 对象
     *
     * @param query SsoConf
     * @return Specification
     */
    public static Specification<SsoConf> querySpecification(Query query) {
        Specification<SsoConf> specification = (Specification<SsoConf>) (root, criteriaQuery, builder) -> {
            List<Predicate> predicates = new ArrayList<>();

            if (query.getTenantId() != null) {
                predicates.add(builder.equal(root.<Long>get("tenantId"), query.getTenantId()));
            }

            if (query.getStatus() != null) {
                predicates.add(builder.equal(root.<Integer>get("status"), query.getStatus()));
            }
            if (StringUtils.isNotBlank(query.getTenantCode())) {
                predicates.add(builder.equal(root.<String>get("tenantCode"), query.getTenantCode()));
            }
            if (StringUtils.isNotBlank(query.getProtocolType())) {
                predicates.add(builder.equal(root.<String>get("protocolType"), query.getProtocolType()));
            }
            if (!predicates.isEmpty()) {
                criteriaQuery.where(predicates.stream().toArray(Predicate[]::new));
            }
            return criteriaQuery.getRestriction();
        };
        return specification;
    }


}
