package com.xforceplus.query;

import com.xforceplus.api.model.TenantModel;
import com.xforceplus.entity.OrgStruct;
import com.xforceplus.entity.Tenant;
import com.xforceplus.entity.User;
import org.apache.commons.lang3.StringUtils;
import org.springframework.data.jpa.domain.Specification;

import javax.persistence.criteria.JoinType;
import javax.persistence.criteria.ListJoin;
import javax.persistence.criteria.Predicate;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Stream;
@SuppressWarnings("all")
public class TenantQueryHelper {
    public static Specification<Tenant> querySpecification(TenantModel.Request.Query query) {
        Specification<Tenant> specification = (Specification<Tenant>) (root, criteriaQuery, builder) -> {
            List<Predicate> predicates = new ArrayList<>();
            boolean joinTable = false;
            if ((query.getUserId() != null && query.getUserId() > 0) || (query.getAccountId() != null && query.getAccountId() > 0)) {
                ListJoin<Tenant, User> joinUser = root.joinList("users", JoinType.LEFT);
                if (query.getAccountId() != null && query.getAccountId() > 0) {
                    predicates.add(builder.equal(joinUser.<Long>get("accountId"), query.getAccountId()));
                }
                if (query.getUserId() != null && query.getUserId() > 0) {
                    predicates.add(builder.equal(joinUser.<Long>get("id"), query.getUserId()));
                }
                if (query.getStatus() != null) {
                    predicates.add(builder.equal(joinUser.get("status"), query.getStatus()));
                }
                joinTable = true;
            }
            if (query.getCompanyId() != null && query.getCompanyId() > 0) {
                ListJoin<Tenant, OrgStruct> joinOrg = root.joinList("orgs", JoinType.LEFT);
                predicates.add(builder.equal(joinOrg.<Long>get("companyId"), query.getCompanyId()));
                if (query.getStatus() != null) {
                    predicates.add(builder.equal(joinOrg.get("status"), query.getStatus()));
                }
                joinTable = true;
            }
            if (StringUtils.isNotBlank(query.getTenantCode())) {
                predicates.add(builder.equal(root.<String>get("tenantCode"), query.getTenantCode()));
            }
            if (query.getStatus() != null) {
                predicates.add(builder.equal(root.<Integer>get("status"), query.getStatus()));
            }
            if (query.getTenantId() != null && query.getTenantId() > 0) {
                predicates.add(builder.equal(root.<Long>get("tenantId"), query.getTenantId()));
            }
            if (StringUtils.isNotBlank(query.getTenantNameEqual())) {
                predicates.add(builder.equal(root.<String>get("tenantName"), query.getTenantNameEqual()));
            } else if (StringUtils.isNotBlank(query.getTenantName())) {
                predicates.add(builder.like(root.get("tenantName"), query.getTenantName() + "%"));
            }
            if (!predicates.isEmpty()) {
                criteriaQuery.where(predicates.stream().toArray(Predicate[]::new));
            }
            if (joinTable) {
                if (criteriaQuery.getResultType().isAssignableFrom(Long.class)) {
                    criteriaQuery.distinct(true);
                    return criteriaQuery.getRestriction();
                } else {
                    criteriaQuery.groupBy(root.<Long>get("tenantId"));
                    return criteriaQuery.getGroupRestriction();
                }
            } else {
                return criteriaQuery.getRestriction();
            }
        };
        return specification;
    }


    public static Specification<Tenant> queryOneSpecification(TenantModel.Request.Query query) {
        Specification<Tenant> specification = (Specification<Tenant>) (root, criteriaQuery, builder) -> {
            Predicate predicate = null;
            if (query.getTenantId() != null && query.getTenantId() > 0) {
                predicate = builder.equal(root.<Long>get("tenantId"), query.getTenantId());
            }
            if (StringUtils.isNotBlank(query.getTenantCode())) {
                if (predicate != null) {
                    predicate = builder.or(predicate, builder.equal(root.<String>get("tenantCode"), query.getTenantCode()));
                } else {
                    predicate = builder.or(builder.equal(root.<String>get("tenantCode"), query.getTenantCode()));
                }

            }
            if (StringUtils.isNotBlank(query.getTenantName())) {
                if (predicate != null) {
                    predicate = builder.or(predicate, builder.equal(root.<String>get("tenantName"), query.getTenantName()));
                } else {
                    predicate = builder.or(builder.equal(root.<String>get("tenantName"), query.getTenantName()));
                }
            }

            if (predicate == null) {
                throw new IllegalArgumentException("参数不合法");
            }
            criteriaQuery.where(Stream.of(predicate).toArray(Predicate[]::new));
            return criteriaQuery.getRestriction();
        };
        return specification;
    }
}
