/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.dao;

import com.xforceplus.dao.CustomizedOrgStructDao;
import com.xforceplus.entity.Company;
import com.xforceplus.entity.OrgStruct;
import io.geewit.data.jpa.essential.repository.JpaBatchRepository;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.data.domain.Sort;
import org.springframework.data.jpa.domain.Specification;
import org.springframework.data.jpa.repository.EntityGraph;
import org.springframework.data.jpa.repository.JpaRepository;
import org.springframework.data.jpa.repository.JpaSpecificationExecutor;
import org.springframework.data.jpa.repository.Modifying;
import org.springframework.data.jpa.repository.Query;
import org.springframework.data.repository.query.Param;
import org.springframework.lang.Nullable;

public interface OrgStructDao
extends JpaRepository<OrgStruct, Long>,
JpaSpecificationExecutor<OrgStruct>,
JpaBatchRepository<OrgStruct, Long>,
CustomizedOrgStructDao {
    @Modifying(clearAutomatically=true)
    @Query(value="delete from OrgStruct o where o.orgId = :orgId")
    public void deleteById(@Param(value="orgId") Long var1);

    @EntityGraph(value="Org.graph", type=EntityGraph.EntityGraphType.LOAD)
    public Page<OrgStruct> findAll(@Nullable Specification<OrgStruct> var1, Pageable var2);

    @EntityGraph(value="Org.graph", type=EntityGraph.EntityGraphType.FETCH)
    public List<OrgStruct> findAll(Specification<OrgStruct> var1);

    @EntityGraph(value="Org.graph", type=EntityGraph.EntityGraphType.FETCH)
    public List<OrgStruct> findAll(Specification<OrgStruct> var1, Sort var2);

    @EntityGraph(value="Org.graph", type=EntityGraph.EntityGraphType.FETCH)
    public Optional<OrgStruct> findById(Long var1);

    @EntityGraph(value="Org.graph", type=EntityGraph.EntityGraphType.FETCH)
    @Query(value="select o from OrgStruct o where o.parentIds like :parentIds% and o.status = 1")
    public List<OrgStruct> findByParentIdsLike(@Param(value="parentIds") String var1);

    @EntityGraph(value="Org.graph", type=EntityGraph.EntityGraphType.FETCH)
    @Query(value="select o from OrgStruct o where o.tenantId = :tenantId and o.orgCode = :orgCode")
    public List<OrgStruct> findByTenantIdAndOrgCode(@Param(value="tenantId") long var1, @Param(value="orgCode") String var3);

    @EntityGraph(value="Org.graph", type=EntityGraph.EntityGraphType.FETCH)
    @Query(value="select o from OrgStruct o where o.tenantId = :tenantId and o.orgCode in (:orgCodes)")
    public List<OrgStruct> findByTenantIdAndOrgCodes(@Param(value="tenantId") long var1, @Param(value="orgCodes") Collection<String> var3);

    @EntityGraph(value="Org.graph", type=EntityGraph.EntityGraphType.FETCH)
    @Query(value="select o from OrgStruct o where o.orgId = :orgId and o.tenantId = :tenantId")
    public OrgStruct findByTenantIdAndOrgId(@Param(value="tenantId") long var1, @Param(value="orgId") long var3);

    @EntityGraph(value="Org.graph", type=EntityGraph.EntityGraphType.FETCH)
    @Query(value="select o from OrgStruct o where o.tenantId = :tenantId and (o.parentId is null or o.parentId = 0)")
    public List<OrgStruct> findRootsByTenantId(@Param(value="tenantId") long var1);

    @Query(value="select o.orgId from OrgStruct o where o.tenantId = :tenantId and o.status = 1 and (o.parentId is null or o.parentId = 0)")
    public List<Long> findRootIdsByTenantId(@Param(value="tenantId") long var1);

    @Query(value="select o.company from OrgStruct o where o.tenantId = :tenantId")
    public List<Company> findCompaniesByTenantId(@Param(value="tenantId") long var1);

    @Query(value="select count(distinct o.companyId) from OrgStruct o where o.tenantId =:tenantId and o.orgType = :#{T(com.xforceplus.tenant.security.core.domain.OrgType).COMPANY} and o.companyId > 0")
    public int countCompaniesByTenantId(@Param(value="tenantId") long var1);

    @Query(value="select o.orgId from OrgStruct o where o.tenantId =:tenantId and o.orgCode = :orgCode")
    public Long findIdByTenantIdAndCode(@Param(value="tenantId") long var1, @Param(value="orgCode") String var3);

    @Modifying(flushAutomatically=true)
    @Query(value="update OrgStruct o set o.status = 1, o.enabledTime = current_timestamp where o.orgId = :orgId")
    public int enable(@Param(value="orgId") long var1);

    @Modifying(flushAutomatically=true)
    @Query(value="update OrgStruct o set o.status = 0, o.disabledTime = current_timestamp where o.orgId = :orgId")
    public int disable(@Param(value="orgId") long var1);

    @Modifying(flushAutomatically=true)
    @Query(value="update OrgStruct o set o.status = 1, o.enabledTime = current_timestamp where o.orgId = :orgId and o.tenantId = :tenantId")
    public int enable(@Param(value="tenantId") long var1, @Param(value="orgId") long var3);

    @Modifying(flushAutomatically=true)
    @Query(value="update OrgStruct o set o.status = 0, o.disabledTime = current_timestamp where o.orgId = :orgId and o.tenantId = :tenantId")
    public int disable(@Param(value="tenantId") long var1, @Param(value="orgId") long var3);

    @Query(value="select o.orgId from OrgStruct o where o.tenantId =:tenantId and o.orgId in (:orgIds)")
    public List<Long> findOrgIdsByTenantIdAndOrgIds(@Param(value="tenantId") long var1, @Param(value="orgIds") Collection<Long> var3);

    @Query(value="select o.parent_ids from sys_org_struct o where o.org_struct_id =:orgId", nativeQuery=true)
    public String findParentIdsByOrgId(@Param(value="orgId") long var1);

    @Modifying(flushAutomatically=true)
    @Query(value="update OrgStruct o set o.companyId = :companyId, o.status = :status, o.auditStatus = :auditStatus, o.enabledTime = current_timestamp where o.orgId = :orgId")
    public void approve(@Param(value="orgId") long var1, @Param(value="companyId") long var3, @Param(value="status") int var5, @Param(value="auditStatus") int var6);

    @Query(value="select o.orgName from OrgStruct o where o.orgId =:orgId")
    public String findNameByOrgId(@Param(value="orgId") long var1);

    @Modifying(flushAutomatically=true)
    @Query(value="update OrgStruct o set o.parentIds = :parentIds where o.orgId = :orgId")
    public void updateParentIds(@Param(value="orgId") long var1, @Param(value="parentIds") String var3);

    @EntityGraph(value="Org.graph", type=EntityGraph.EntityGraphType.FETCH)
    @Query(value="select o from OrgStruct o where o.tenantId = :tenantId")
    public List<OrgStruct> findByTenantId(@Param(value="tenantId") long var1);

    @Query(value="select count(o.orgId) from OrgStruct o where o.parentId = :orgId and o.status = 1")
    public long countChildren(@Param(value="orgId") long var1);

    @Query(value="select count(o.orgId) from OrgStruct o where o.tenantId = :tenantId and o.parentId = :orgId and o.status = 1")
    public long countTenantChildren(@Param(value="tenantId") long var1, @Param(value="orgId") long var3);

    @Query(value="select o.orgId from OrgStruct o where o.tenantId = :tenantId and o.orgId = :orgId")
    public Long findOrgIdByTenantIdAndOrgId(@Param(value="tenantId") long var1, @Param(value="orgId") long var3);

    @Query(value="select count(o.orgId) from OrgStruct o where o.tenantId = :tenantId and o.status = 1 and o.parentId is not null")
    public long countTenantWithoutRoot(@Param(value="tenantId") long var1);

    @Query(value="select o.orgId from OrgStruct o where o.tenantId = :tenantId and o.orgCode = :orgCode")
    public List<Long> findOrgIdByTenantIdAndOrgCode(@Param(value="tenantId") long var1, @Param(value="orgCode") String var3);

    @Query(value="select o.parent_ids from sys_org_struct o where o.org_struct_id in (:orgIds)", nativeQuery=true)
    public Set<String> findParentIdsByOrgIds(@Param(value="orgIds") Collection<Long> var1);

    @Query(value="select o.parent_ids from sys_org_struct o where o.org_code=:orgCode", nativeQuery=true)
    public Set<String> findParentIdsByOrgCode(@Param(value="orgCode") String var1);

    @Query(value="select o.orgId from OrgStruct o where o.parentIds like :parentIds and o.status = 1")
    public Set<Long> findOrgIdsByParentIdsLike(@Param(value="parentIds") String var1);

    @Query(value="select o from OrgStruct o where o.tenantId = :tenantId and o.companyId = :companyId")
    public List<OrgStruct> findByTenantIdAndCompanyId(@Param(value="tenantId") long var1, @Param(value="companyId") long var3);

    @Query(value="select count(o) from OrgStruct o where o.parentId = :parentId and o.companyId = :companyId")
    public long countCompaniesByParentIdAndCompanyId(@Param(value="parentId") long var1, @Param(value="companyId") long var3);

    @Query(value="select o from OrgStruct o where o.orgId in (:orgIds)")
    public List<OrgStruct> findByOrgIds(@Param(value="orgIds") Collection<Long> var1);

    public List<OrgStruct> findByCompanyId(Long var1);
}

