/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.dao;

import com.xforceplus.entity.OrgStruct;
import com.xforceplus.entity.OrgUserRel;
import com.xforceplus.entity.User;
import io.geewit.data.jpa.essential.repository.JpaBatchRepository;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.data.jpa.repository.EntityGraph;
import org.springframework.data.jpa.repository.JpaRepository;
import org.springframework.data.jpa.repository.JpaSpecificationExecutor;
import org.springframework.data.jpa.repository.Modifying;
import org.springframework.data.jpa.repository.Query;
import org.springframework.data.repository.query.Param;
import org.springframework.transaction.annotation.Transactional;

public interface OrgUserRelDao
extends JpaRepository<OrgUserRel, Long>,
JpaSpecificationExecutor<OrgUserRel>,
JpaBatchRepository<OrgUserRel, Long> {
    @Transactional
    public OrgUserRel saveAndFlush(OrgUserRel var1);

    @Modifying(clearAutomatically=true)
    @Query(value="delete from OrgUserRel rel where rel.id = :id")
    public void deleteById(@Param(value="id") Long var1);

    @Query(value="select rel.org from OrgUserRel rel where rel.userId = :userId")
    public List<OrgStruct> findOrgsByUserId(@Param(value="userId") long var1);

    @Query(value="select rel.user from OrgUserRel rel where rel.orgStructId = :orgId")
    public Page<User> findByOrgId(@Param(value="orgId") long var1, Pageable var3);

    @Modifying(clearAutomatically=true)
    @Query(value="delete from OrgUserRel rel where rel.userId = :userId and rel.orgStructId = :orgId")
    public void deleteByUserIdAndOrgId(@Param(value="userId") long var1, @Param(value="orgId") long var3);

    @Query(value="select rel from OrgUserRel rel where rel.userId = :userId")
    public List<OrgUserRel> findByUserId(@Param(value="userId") long var1);

    @Modifying(clearAutomatically=true)
    @Query(value="delete from OrgUserRel rel where rel.tenantId = :tenantId and rel.userId = :userId and rel.orgStructId = :orgId")
    public void deleteByTenantIdAndUserIdAndOrgId(@Param(value="tenantId") long var1, @Param(value="userId") long var3, @Param(value="orgId") Long var5);

    @Modifying(clearAutomatically=true)
    @Query(value="delete from OrgUserRel rel where rel.userId = :userId")
    public void deleteByUserId(@Param(value="userId") long var1);

    @Query(value="select rel.orgStructId from OrgUserRel rel where rel.userId = :userId")
    public List<Long> findOrgIdsByUserId(@Param(value="userId") long var1);

    @Query(value="select rel.userId from OrgUserRel rel where rel.orgStructId = :orgId")
    public Set<Long> findUserIdsByOrgId(@Param(value="orgId") long var1);

    public List<OrgUserRel> findByTenantId(Long var1);

    @Query(value="SELECT rel.user_id FROM sys_org_user_rel rel LEFT join sys_org_struct o on o.org_struct_id = rel.org_struct_id WHERE o.parent_ids like :parentIds", nativeQuery=true)
    public Set<Long> findUserIdsByParentIdsLike(@Param(value="parentIds") String var1);

    @Query(value="select rel.userId from OrgUserRel rel where rel.orgStructId in(:orgIds) ")
    public Set<Long> findUserIdsByOrgIds(@Param(value="orgIds") Collection<Long> var1);

    @EntityGraph(value="OrgUserRel.graph", type=EntityGraph.EntityGraphType.FETCH)
    @Query(value="select rel from OrgUserRel rel where rel.orgStructId in(:orgIds) ")
    public Set<OrgUserRel> findRelsByOrgIds(@Param(value="orgIds") Collection<Long> var1);

    @Modifying(flushAutomatically=true)
    @Query(value="update OrgUserRel rel set rel.tenantId = :tenantId where rel.id in (:orgUserRelIds)")
    public void batchUpdateTenant(@Param(value="orgUserRelIds") List<Long> var1, @Param(value="tenantId") Long var2);

    @Modifying(flushAutomatically=true)
    @Query(value="delete from OrgUserRel rel  where rel.id in (:orgUserRelIds)")
    public void batchDelete(@Param(value="orgUserRelIds") List<Long> var1);
}

