/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.dao;

import com.xforceplus.dao.CustomizedRoleDao;
import com.xforceplus.entity.Role;
import io.geewit.data.jpa.essential.repository.JpaBatchRepository;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import org.springframework.data.jpa.repository.EntityGraph;
import org.springframework.data.jpa.repository.JpaRepository;
import org.springframework.data.jpa.repository.JpaSpecificationExecutor;
import org.springframework.data.jpa.repository.Modifying;
import org.springframework.data.jpa.repository.Query;
import org.springframework.data.repository.query.Param;

public interface RoleDao
extends JpaRepository<Role, Long>,
JpaSpecificationExecutor<Role>,
JpaBatchRepository<Role, Long>,
CustomizedRoleDao {
    @Modifying(clearAutomatically=true)
    @Query(value="delete from Role r where r.id = :id")
    public void deleteById(@Param(value="id") Long var1);

    @EntityGraph(value="Role.graph", type=EntityGraph.EntityGraphType.FETCH)
    public Optional<Role> findById(Long var1);

    @Query(value="select r from Role r where r.name = :name")
    public List<Role> findByName(@Param(value="name") String var1);

    @Query(value="select r from Role r where r.name = :name and r.id<>:roleId")
    public List<Role> findByNameAndId(@Param(value="name") String var1, @Param(value="roleId") Long var2);

    @Query(value="select r from Role r where r.tenantId = :tenantId and r.code in (:roleCodes)")
    public List<Role> findByTenantIdAndRoleCodes(@Param(value="tenantId") long var1, @Param(value="roleCodes") Collection<String> var3);

    @Modifying
    @Query(value="update Role r set r.status = :status where r.id = :roleId and r.tenantId = :tenantId")
    public int updateStatus(@Param(value="tenantId") long var1, @Param(value="roleId") long var3, @Param(value="status") int var5);

    @Modifying
    @Query(value="update Role r set r.status = :status where r.id = :roleId")
    public int updateStatus(@Param(value="roleId") long var1, @Param(value="status") int var3);

    @Query(value="select r from Role r where r.tenantId = :tenantId and r.fromRoleId =:fromRoleId")
    public Role findByTenantIdAndFromRoleId(@Param(value="tenantId") long var1, @Param(value="fromRoleId") long var3);

    @Query(value="select r.id from Role r where r.tenantId = :tenantId and r.code =:roleCode")
    public Long findIdByTenantIdAndCode(@Param(value="tenantId") long var1, @Param(value="roleCode") String var3);

    @Query(value="select r from Role r where r.tenantId = :tenantId and r.code =:roleCode")
    public Role findByTenantIdAndCode(@Param(value="tenantId") long var1, @Param(value="roleCode") String var3);

    @Query(value="select r from Role r where r.tenantId = :tenantId and r.code =:roleCode")
    public List<Role> findByListTenantIdAndCode(@Param(value="tenantId") long var1, @Param(value="roleCode") String var3);

    @Query(value="select count(r.id) from Role r where r.tenantId = :tenantId and r.code =:roleCode and r.id <> :currentId")
    public long countDifferentByTenantIdAndCode(@Param(value="tenantId") long var1, @Param(value="currentId") long var3, @Param(value="roleCode") String var5);

    @Query(value="select count(r.id) from Role r where r.tenantId = :tenantId and r.name =:roleName and r.id <> :currentId")
    public long countDifferentByTenantIdAndName(@Param(value="tenantId") long var1, @Param(value="currentId") long var3, @Param(value="roleName") String var5);

    public List<Role> findByTenantId(Long var1);

    @Modifying(flushAutomatically=true)
    @Query(value="update Role r set r.tenantId = :tenantId where r.id in (:roleIds)")
    public void batchUpdateTenant(@Param(value="roleIds") List<Long> var1, @Param(value="tenantId") Long var2);
}

