/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.dao.company.impl;

import com.xforceplus.dao.company.CompanyHisExtendDao;
import com.xforceplus.data.query.StringQuery;
import com.xforceplus.data.repository.AbstractDefaultJpaRepositoryImpl;
import com.xforceplus.domain.company.CompanyHisDTO;
import com.xforceplus.entity.Company;
import java.util.List;
import java.util.Optional;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Repository;
import org.springframework.util.Assert;
import org.springframework.util.CollectionUtils;

@Repository
public class CompanyHisExtendDaoImpl
extends AbstractDefaultJpaRepositoryImpl
implements CompanyHisExtendDao {
    private static final int EFFECTIVE_VALID = 1;
    private static final String SQL_COMPANY_HIS_TAX_NUM = "select bc.* from bss_company bc where bc.company_id =  (select company_id from bss_company_audit  bca  where    bca.is_effective=:effective and bca.tax_num=:taxNum  LIMIT 1)";
    private static final String SQL_COMPANY_HIS_TAX_NUM_PAGE = "select bc.* from bss_company bc where bc.company_id in  (select company_id from bss_company_audit  bca  where    bca.is_effective=:effective and bca.tax_num=:taxNum)";
    private static final String SQL_COMPANY_HIS_BY_TAX_NUM = "select bca.company_id,bca.company_name,bca.tax_num,bca.effective_date,bca.is_effective as effective from bss_company_audit  bca where bca.tax_num=:taxNum";

    @Override
    public Optional<Company> findCompanyByHisTaxNum(String taxNum) {
        Assert.hasText((String)taxNum, (String)"\u7a0e\u53f7\u4e0d\u4e3a\u7a7a");
        StringQuery stringQuery = StringQuery.builder().query(SQL_COMPANY_HIS_TAX_NUM).predicate(true).param("taxNum", taxNum).param("effective", 1).build();
        List<Company> companyList = this.findBySql(stringQuery, Company.class, Boolean.TRUE);
        if (CollectionUtils.isEmpty(companyList)) {
            return Optional.empty();
        }
        return Optional.ofNullable(companyList.get(0));
    }

    @Override
    public Page<CompanyHisDTO> hisPageByTaxNum(String taxNum, Pageable pageable) {
        Assert.hasText((String)taxNum, (String)"\u7a0e\u53f7\u4e0d\u4e3a\u7a7a");
        StringQuery stringQuery = StringQuery.builder().query(SQL_COMPANY_HIS_BY_TAX_NUM).predicate(true).param("taxNum", taxNum).build();
        return super.pagingSqlBy(pageable, stringQuery.getQuery(), stringQuery.getParams(), CompanyHisDTO.class, Boolean.TRUE);
    }

    @Override
    public Page<Company> page(String taxNum, Pageable pageable) {
        Assert.hasText((String)taxNum, (String)"\u7a0e\u53f7\u4e0d\u4e3a\u7a7a");
        StringQuery stringQuery = StringQuery.builder().query(SQL_COMPANY_HIS_TAX_NUM_PAGE).predicate(true).param("taxNum", taxNum).param("effective", 1).build();
        return super.pagingSqlBy(pageable, stringQuery.getQuery(), stringQuery.getParams(), Company.class, Boolean.TRUE);
    }
}

