/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.dao.impl;

import com.xforceplus.bo.org.OrgCompanyQueryBo;
import com.xforceplus.bo.org.OrgUserStatisticsQueryBo;
import com.xforceplus.dao.OrgExtendDao;
import com.xforceplus.data.query.StringQuery;
import com.xforceplus.data.repository.AbstractDefaultJpaRepositoryImpl;
import com.xforceplus.domain.org.OrgDto;
import com.xforceplus.dto.org.OrgCompanyDTO;
import com.xforceplus.dto.org.OrgCompanyNoDTO;
import com.xforceplus.dto.org.OrgParentDTO;
import com.xforceplus.dto.org.OrgUserStatisticsDTO;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Repository;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.Assert;

@Repository
public class OrgExtendDaoImpl
extends AbstractDefaultJpaRepositoryImpl
implements OrgExtendDao {
    private static final Logger log = LoggerFactory.getLogger(OrgExtendDaoImpl.class);

    @Override
    @Transactional(readOnly=true)
    public List<OrgDto> getOrgByTenantCodeAndOrgCode(String tenantCode, String orgCode) {
        StringQuery query = StringQuery.builder().query("select  sos.org_struct_id as org_id from bss_tenant bt \ninner join sys_org_struct sos on sos.tenant_id = bt.tenant_id \n where 1=1 and sos.status = 1 ").predicateNotNull(tenantCode).query(" and bt.tenant_code = :tenantCode ").param("tenantCode", tenantCode).predicateNotNull(orgCode).query(" and sos.org_code = :orgCode ").param("orgCode", orgCode).build();
        return this.findBySql(query, OrgDto.class, Boolean.TRUE);
    }

    @Override
    public List<OrgCompanyDTO> findOrgCompanyByTaxNum(OrgCompanyQueryBo queryBo) {
        Assert.hasText((String)queryBo.getTaxNum(), (String)"\u516c\u53f8\u7a0e\u53f7\u4e0d\u80fd\u4e3a\u7a7a");
        StringQuery stringQuery = StringQuery.builder().query("select sos.tenant_id,sos.company_id,bc.company_code,bc.company_name,bc.tax_num,sos.org_struct_id as org_id,sos.org_name,   sos.org_code from  sys_org_struct  sos,bss_company  bc,  bss_tenant tenant    where   sos.company_id=bc.company_id and  bc.tax_num=:taxNum  and sos.tenant_id = tenant.tenant_id  ").param("taxNum", queryBo.getTaxNum()).predicateNotNull(queryBo.getCompanyId()).query(" and  bc.company_id=:companyId ").param("companyId", queryBo.getCompanyId()).predicateNotNull(queryBo.getOrgId()).query(" and  sos.org_struct_id=:orgId ").param("orgId", queryBo.getOrgId()).predicateNotNull(queryBo.getTenantCode()).query(" and  tenant.tenant_code=:tenantCode ").param("tenantCode", queryBo.getTenantCode()).predicateNotNull(queryBo.getTenantId()).query(" and  sos.tenant_id=:tenantId ").param("tenantId", queryBo.getTenantId()).predicate(true).query(" order by sos.org_struct_id desc ").build();
        return this.findBySql(stringQuery, OrgCompanyDTO.class, Boolean.TRUE);
    }

    @Override
    public List<OrgCompanyNoDTO> findCompanyNoByOrgIds(List<Long> orgIds) {
        StringQuery stringQuery = StringQuery.builder().query("select org_struct_id as org_id,company_no from sys_org_companyno soc where ").query("  soc.org_struct_id in(:orgIds)").predicate(true).param("orgIds", orgIds).build();
        return this.findBySql(stringQuery, OrgCompanyNoDTO.class, Boolean.TRUE);
    }

    @Override
    public List<OrgUserStatisticsDTO> findUserStatisticsByOrgIds(OrgUserStatisticsQueryBo queryBo) {
        Assert.notEmpty(queryBo.getOrgIds(), (String)"\u7ec4\u7ec7ID\u5217\u8868\u4e0d\u80fd\u4e3a\u7a7a");
        log.info("OrgUserStatisticsQueryBo:{}", (Object)queryBo.toString());
        StringQuery stringQuery = StringQuery.builder().query(" select ur.org_struct_id as org_id,count(*) as user_total_num ").query(" from sys_org_user_rel ur where org_struct_id IN(:orgIds) ").predicate(true).inParam("orgIds", queryBo.getOrgIds()).predicateNotNull(queryBo.getTenantId()).query("  and  ur.tenant_id=:tenantId ").param("tenantId", queryBo.getTenantId()).predicate(true).query(" group by ur.org_struct_id ").build();
        return super.findBySql(stringQuery, OrgUserStatisticsDTO.class, Boolean.TRUE);
    }

    @Override
    public List<OrgParentDTO> findOrgParentByOrgIds(List<Long> orgIds) {
        Assert.notEmpty(orgIds, (String)"\u7ec4\u7ec7ID\u5217\u8868\u4e0d\u80fd\u4e3a\u7a7a");
        StringQuery stringQuery = StringQuery.builder().query("select org_struct_id as org_id ,org_name from sys_org_struct where org_struct_id in (:orgIds)").inParam("orgIds", orgIds).build();
        return super.findBySql(stringQuery, OrgParentDTO.class, Boolean.TRUE);
    }
}

