/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.dao.impl;

import com.xforceplus.bo.ResourceQueryBo;
import com.xforceplus.dao.ResourceExtendDao;
import com.xforceplus.data.query.StringQuery;
import com.xforceplus.data.repository.AbstractDefaultJpaRepositoryImpl;
import com.xforceplus.dto.resource.ResourceDTO;
import com.xforceplus.dto.resource.ResourceServiceApiDTO;
import com.xforceplus.dto.resource.ServiceApiRouterDTO;
import com.xforceplus.dto.resource.ServicePackageDTO;
import java.util.List;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Repository;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;

@Repository
public class ResourceExtendDaoImpl
extends AbstractDefaultJpaRepositoryImpl
implements ResourceExtendDao {
    public static final String QUERY_RESOURCE = "SELECT sr.resource_id,sr.resource_name, sr.resource_code, sr.app_id, pr.resource_code AS parent_code,sr.parent_id   FROM sys_resource sr LEFT JOIN sys_resource pr ON sr.parent_id = pr.resource_id where 1=1 ";
    public static final String QUERY_RESOURCE_SERVICE_API = "SELECT ssa.service_api_id,    ssa.service_api_name,    ssa.service_api_path,    ssa.service_api_url,    ssa.route_id,    sr.app_id,    ssa.request_method,    sr.resource_code,    sr.resource_id    FROM    sys_service_api ssa    INNER JOIN sys_resource_api_rel srar ON ssa.service_api_id = srar.service_api_id    INNER JOIN sys_resource sr ON srar.resource_id = sr.resource_id where 1=1 ";

    @Override
    public List<ServiceApiRouterDTO> findRouteAll() {
        StringQuery query = StringQuery.builder().query("select route_id,path from bss_route").build();
        return this.findBySql(query, ServiceApiRouterDTO.class, Boolean.TRUE);
    }

    @Override
    public Page<ResourceDTO> pagingBy(Pageable pageable, ResourceQueryBo queryBo) {
        StringQuery query = StringQuery.builder().query(QUERY_RESOURCE);
        if (!CollectionUtils.isEmpty(queryBo.getResourceIds())) {
            query.predicateNotEmpty(queryBo.getResourceIds()).query("  and sr.resource_id in(:resourceIds)").inParam("resourceIds", queryBo.getResourceIds()).build();
        } else {
            query = query.predicateHasText(queryBo.getResourceName()).query(" and  sr.resource_name like :resourceName").likeParam("resourceName", queryBo.getResourceName()).predicateHasText(queryBo.getResourceCode()).query(" and  sr.resource_code like :resourceCode").likeParam("resourceCode", queryBo.getResourceCode()).predicateNotNull(queryBo.getAppId()).query(" and sr.app_id=:appId").param("appId", queryBo.getAppId()).build();
        }
        return super.pagingSqlBy(pageable, query.getQuery(), query.getParams(), ResourceDTO.class, Boolean.TRUE);
    }

    @Override
    public Page<ResourceServiceApiDTO> pagingByServiceApi(Pageable pageable, ResourceQueryBo queryBo) {
        StringQuery query = StringQuery.builder().query(QUERY_RESOURCE_SERVICE_API);
        query = !CollectionUtils.isEmpty(queryBo.getResourceIds()) ? query.predicateNotEmpty(queryBo.getResourceIds()).query("  and sr.resource_id in(:resourceIds)").inParam("resourceIds", queryBo.getResourceIds()).build() : query.predicateHasText(queryBo.getResourceName()).query(" and  sr.resource_name like :resourceName").likeParam("resourceName", queryBo.getResourceName()).predicateHasText(queryBo.getResourceCode()).query(" and  sr.resource_code like :resourceCode").likeParam("resourceCode", queryBo.getResourceCode()).predicateNotNull(queryBo.getAppId()).query(" and sr.app_id=:appId").param("appId", queryBo.getAppId()).build();
        return super.pagingSqlBy(pageable, query.getQuery(), query.getParams(), ResourceServiceApiDTO.class, Boolean.TRUE);
    }

    @Override
    public List<ResourceDTO> getUserRoleResourceCode(Long userId) {
        if (userId == null || userId <= 0L) {
            throw new IllegalArgumentException("userId \u4e0d\u5408\u6cd5");
        }
        StringQuery query = StringQuery.builder().query("select distinct sr.resource_id, sr.resource_code from sys_role_user_rel srur inner join sys_role_resourceset_rel srrr on srur.role_id = srrr.role_id inner join sys_resourceset_resource_rel srsrr on srsrr.resourceset_id = srrr.resouseset_id inner join sys_resource sr on sr.resource_id = srsrr.resource_id where 1=1 ").predicate(userId > 0L).query("  and srur.user_id =:userId").param("userId", userId).build();
        return super.findBySql(query, ResourceDTO.class, true);
    }

    @Override
    @Transactional(readOnly=true)
    public List<ServicePackageDTO> getServicePackIdByUserIdAndAppId(Long userId, Long appId) {
        if (userId == null || userId <= 0L) {
            throw new IllegalArgumentException("userId \u4e0d\u5408\u6cd5");
        }
        if (appId == null || appId <= 0L) {
            throw new IllegalArgumentException("appId \u4e0d\u5408\u6cd5");
        }
        StringQuery query = StringQuery.builder().query("  select  distinct  bcsr.service_package_id\n from   sys_org_user_rel sour \n inner join sys_org_struct sos on sour.org_struct_id = sos.org_struct_id  \n inner join bss_company bc on bc.company_id  = sos.company_id  \n inner join bss_company_service_rel bcsr on bcsr.company_id = bc.company_id  \n inner join bss_service_package  bsp on bsp.service_package_id = bcsr.service_package_id  where 1=1 ").predicate(userId > 0L).query(" and sour.user_id =:userId").param("userId", userId).predicate(appId > 0L).query(" and bsp.app_id =:appId").param("appId", appId).build();
        return super.findBySql(query, ServicePackageDTO.class, true);
    }

    @Override
    @Transactional(readOnly=true)
    public List<ResourceDTO> getUserCompanyResourceByPackageIdList(List<Long> servicePackageList) {
        if (CollectionUtils.isEmpty(servicePackageList)) {
            throw new IllegalArgumentException("servicePackageList \u4e3a\u7a7a\uff01");
        }
        StringQuery query = StringQuery.builder().query("  select distinct sr.resource_id, sr.resource_code \n from  sys_resourceset_resource_rel srsrr\n inner join  bss_service_resourceset_rel bsrr on srsrr.resourceset_id = bsrr.resourceset_id  \n inner join sys_resource sr on sr.resource_id = srsrr.resource_id  \n where 1=1 ").predicate(!CollectionUtils.isEmpty(servicePackageList)).query(" and bsrr.service_package_id in (:servicePackageList) ").inParam("servicePackageList", servicePackageList).build();
        return super.findBySql(query, ResourceDTO.class, true);
    }
}

