/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.data.query;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;

public class StringQueryUtils {
    public static final String COUNT_QUERY_STRING = "select count(%s) from %s x";

    public static String queryString(String template, String entityName) {
        Assert.hasText((String)entityName, (String)"Entity name must not be null or empty!");
        return String.format(template, entityName);
    }

    public static String countQueryString(String entityName) {
        String countQuery = String.format(COUNT_QUERY_STRING, "x", "%s");
        return StringQueryUtils.queryString(countQuery, entityName);
    }

    public static String genCountQueryString(String queryString) {
        return "select count(*) " + StringQueryUtils.removeSelect(queryString);
    }

    public static String removeSelect(String queryString) {
        Assert.hasText((String)queryString, (String)"Query  must not be null!");
        queryString = StringQueryUtils.removeFetch(queryString);
        queryString = StringQueryUtils.removeOrderBy(queryString);
        int beginPos = queryString.toLowerCase().indexOf("from");
        Assert.isTrue((beginPos != -1 ? 1 : 0) != 0, (String)(" the jpql : " + queryString + " must has a keyword 'from'"));
        return queryString.substring(beginPos);
    }

    public static String removeOrderBy(String queryString) {
        Assert.hasText((String)queryString, (String)"Query  must not be null!");
        queryString = StringQueryUtils.removeFetch(queryString);
        int beginPos = queryString.toLowerCase().indexOf("order by ");
        if (beginPos == -1) {
            return queryString;
        }
        return queryString.substring(0, beginPos);
    }

    public static String removeOrders(String queryString) {
        Pattern pattern = Pattern.compile("order\\s*by[\\w|\\W|\\s|\\S]*", 2);
        Matcher matcher = pattern.matcher(queryString);
        StringBuffer stringBuffer = new StringBuffer();
        while (matcher.find()) {
            matcher.appendReplacement(stringBuffer, "");
        }
        matcher.appendTail(stringBuffer);
        return stringBuffer.toString();
    }

    public static String removeFetch(String queryString) {
        Assert.hasText((String)queryString, (String)"Query  must not be null!");
        return StringUtils.delete((String)queryString, (String)" fetch");
    }
}

