/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.jpa.listener;

import com.xforceplus.entity.SsoSaml;
import com.xforceplus.tenant.security.core.context.UserInfoHolder;
import com.xforceplus.tenant.security.core.domain.IAuthorizedUser;
import java.util.Date;
import javax.persistence.PrePersist;
import javax.persistence.PreUpdate;
import org.apache.commons.lang3.StringUtils;

public class SsoSamlConfListener {
    @PrePersist
    protected void beforeInsert(SsoSaml entity) {
        IAuthorizedUser authorizedUser = UserInfoHolder.get();
        if (authorizedUser != null) {
            entity.setCreateUserId(String.valueOf(authorizedUser.getId()));
            entity.setCreateTime(new Date());
            if (authorizedUser.getOperaterName() != null) {
                entity.setUpdateUserName(authorizedUser.getOperaterName());
            } else {
                entity.setUpdateUserName("");
            }
        }
        if (StringUtils.isBlank((CharSequence)entity.getSignAlgorithm())) {
            entity.setSignAlgorithm("http://www.w3.org/2001/04/xmldsig-more#rsa-sha256");
        }
    }

    @PreUpdate
    protected void beforeUpdate(SsoSaml entity) {
        IAuthorizedUser authorizedUser = UserInfoHolder.get();
        if (authorizedUser != null) {
            entity.setUpdateUserId(String.valueOf(authorizedUser.getId()));
            entity.setUpdateTime(new Date());
            if (authorizedUser.getOperaterName() != null) {
                entity.setUpdateUserName(authorizedUser.getOperaterName());
            } else {
                entity.setUpdateUserName("");
            }
        }
    }
}

