/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.query;

import com.xforceplus.api.model.CompanyApplyModel;
import com.xforceplus.entity.CompanyApply;
import java.io.Serializable;
import java.util.ArrayList;
import javax.persistence.criteria.Expression;
import javax.persistence.criteria.Predicate;
import org.apache.commons.lang3.StringUtils;
import org.springframework.data.jpa.domain.Specification;

public class CompanyApplyQueryHelper {
    public static final String TAX_NUM = "taxNum";
    public static final String COMPANY_NAME = "companyName";
    public static final String COMPANY_CODE = "companyCode";
    public static final String TENANT_ID = "tenantId";
    public static final String COMPANY_ID = "companyId";
    public static final String STATUS = "status";

    public static Specification<CompanyApply> querySpecification(CompanyApplyModel.Request.Query query) {
        Specification & Serializable specification = (Specification & Serializable)(root, criteriaQuery, builder) -> {
            ArrayList<Predicate> predicates = new ArrayList<Predicate>();
            if (query.getTenantId() != null && query.getTenantId() > 0) {
                predicates.add(builder.equal((Expression)root.get(TENANT_ID), (Object)query.getTenantId()));
            }
            if (StringUtils.isNotBlank((CharSequence)query.getCompanyCode())) {
                predicates.add(builder.equal((Expression)root.get(COMPANY_CODE), (Object)query.getCompanyCode()));
            }
            if (StringUtils.isNotBlank((CharSequence)query.getTaxNum())) {
                predicates.add(builder.equal((Expression)root.get(TAX_NUM), (Object)query.getTaxNum()));
            }
            if (StringUtils.isNotBlank((CharSequence)query.getCompanyName())) {
                predicates.add(builder.like((Expression)root.get(COMPANY_NAME), query.getCompanyName() + "%"));
            }
            if (query.getCompanyId() != null && query.getCompanyId() > 0L) {
                predicates.add(builder.equal((Expression)root.get(COMPANY_ID), (Object)query.getCompanyId()));
            }
            if (query.getStatus() != null) {
                predicates.add(builder.equal((Expression)root.get(STATUS), (Object)query.getStatus()));
            }
            if (!predicates.isEmpty()) {
                criteriaQuery.where((Predicate[])predicates.stream().toArray(Predicate[]::new));
            }
            return criteriaQuery.getRestriction();
        };
        return specification;
    }

    public static Specification<CompanyApply> queryOneSpecification(CompanyApplyModel.Request.Query query) {
        Specification & Serializable specification = (Specification & Serializable)(root, criteriaQuery, builder) -> {
            ArrayList<Predicate> predicates = new ArrayList<Predicate>();
            if (query.getTenantId() != null && query.getTenantId() > 0) {
                predicates.add(builder.equal((Expression)root.get(TENANT_ID), (Object)query.getTenantId()));
            }
            if (query.getCompanyId() != null && query.getCompanyId() > 0L) {
                predicates.add(builder.equal((Expression)root.get(COMPANY_ID), (Object)query.getCompanyId()));
            }
            if (StringUtils.isNotBlank((CharSequence)query.getCompanyCode()) || StringUtils.isNotBlank((CharSequence)query.getTaxNum()) || StringUtils.isNotBlank((CharSequence)query.getCompanyName())) {
                Predicate predicate = builder.disjunction();
                if (StringUtils.isNotBlank((CharSequence)query.getCompanyCode())) {
                    predicate = builder.or((Expression)predicate, (Expression)builder.equal((Expression)root.get(COMPANY_CODE), (Object)query.getCompanyCode()));
                }
                if (StringUtils.isNotBlank((CharSequence)query.getTaxNum())) {
                    predicate = builder.or((Expression)predicate, (Expression)builder.equal((Expression)root.get(TAX_NUM), (Object)query.getTaxNum()));
                }
                if (StringUtils.isNotBlank((CharSequence)query.getCompanyName())) {
                    predicate = builder.or((Expression)predicate, (Expression)builder.equal((Expression)root.get(COMPANY_NAME), (Object)query.getCompanyName()));
                }
                if (predicate != null) {
                    predicates.add(predicate);
                }
            }
            if (query.getStatus() != null) {
                predicates.add(builder.equal((Expression)root.get(STATUS), (Object)query.getStatus()));
            }
            if (predicates.isEmpty()) {
                throw new IllegalArgumentException("\u67e5\u8be2\u53c2\u6570\u4e0d\u5408\u6cd5");
            }
            criteriaQuery.where((Predicate[])predicates.stream().toArray(Predicate[]::new));
            return criteriaQuery.getRestriction();
        };
        return specification;
    }
}

