/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.query;

import com.xforceplus.api.model.RoleModel;
import com.xforceplus.entity.Role;
import com.xforceplus.entity.RoleUserRel;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import javax.persistence.criteria.CriteriaBuilder;
import javax.persistence.criteria.Expression;
import javax.persistence.criteria.Join;
import javax.persistence.criteria.JoinType;
import javax.persistence.criteria.ListJoin;
import javax.persistence.criteria.Predicate;
import javax.persistence.criteria.Root;
import javax.persistence.criteria.Subquery;
import org.apache.commons.lang3.StringUtils;
import org.springframework.data.jpa.domain.Specification;

public class RoleQueryHelper {
    public static Specification<Role> querySpecification(RoleModel.Request.Query query) {
        Specification & Serializable specification = (Specification & Serializable)(root, criteriaQuery, builder) -> {
            ArrayList<Object> predicates = new ArrayList<Object>();
            boolean joinTable = false;
            if (query.getId() != null && query.getId() > 0L) {
                predicates.add(builder.equal((Expression)root.get("id"), (Object)query.getId()));
            } else {
                if (query.getExcludeBoundCurrent() != null && query.getTenantId() != null && query.getTenantId() > 0L && query.getExcludeBoundCurrent().booleanValue() && query.getUserId() != null && query.getUserId() > 0L) {
                    Subquery subquery = criteriaQuery.subquery(RoleUserRel.class);
                    Root roleUserRel = subquery.from(RoleUserRel.class);
                    subquery.select((Expression)roleUserRel);
                    Predicate[] subPredicates = new Predicate[]{builder.equal((Expression)roleUserRel.get("userId"), (Object)query.getUserId()), builder.equal((Expression)root.get("id"), (Expression)roleUserRel.get("roleId"))};
                    subquery.where(subPredicates);
                    predicates.add(builder.not((Expression)builder.exists(subquery)));
                } else if (query.getUserId() != null && query.getUserId() > 0L || query.getAccountId() != null && query.getAccountId() > 0L) {
                    ListJoin joinRoleUserRels = root.joinList("roleUserRels", JoinType.LEFT);
                    if (query.getUserId() != null && query.getUserId() > 0L) {
                        predicates.add(builder.equal((Expression)joinRoleUserRels.get("userId"), (Object)query.getUserId()));
                    }
                    if (query.getAccountId() != null && query.getAccountId() > 0L) {
                        Join joinUser = joinRoleUserRels.join("user", JoinType.LEFT);
                        predicates.add(builder.equal((Expression)joinUser.get("accountId"), (Object)query.getAccountId()));
                    }
                    joinTable = true;
                }
                if (StringUtils.isNotBlank((CharSequence)query.getRoleCode())) {
                    if (query.getRoleCode().contains(";")) {
                        String[] codes = query.getRoleCode().split(";");
                        if (codes.length > 1) {
                            CriteriaBuilder.In in = builder.in((Expression)root.get("code"));
                            Arrays.stream(codes).forEach(arg_0 -> ((CriteriaBuilder.In)in).value(arg_0));
                            predicates.add(in);
                        } else if (codes.length == 1) {
                            predicates.add(builder.equal((Expression)root.get("code"), (Object)codes[0]));
                        }
                    } else {
                        predicates.add(builder.equal((Expression)root.get("code"), (Object)query.getRoleCode()));
                    }
                }
                if (StringUtils.isNotBlank((CharSequence)query.getSearchKey())) {
                    predicates.add(builder.or((Expression)builder.like((Expression)root.get("name"), query.getSearchKey() + "%"), (Expression)builder.equal((Expression)root.get("code"), (Object)query.getSearchKey())));
                }
                if (StringUtils.isNotBlank((CharSequence)query.getRoleName())) {
                    predicates.add(builder.equal((Expression)root.get("name"), (Object)query.getRoleName()));
                }
                if (query.getFromRoleId() != null && query.getFromRoleId() > 0L) {
                    predicates.add(builder.equal((Expression)root.get("fromRoleId"), (Object)query.getFromRoleId()));
                }
                if (query.getStatus() != null) {
                    predicates.add(builder.equal((Expression)root.get("status"), (Object)query.getStatus()));
                }
            }
            Boolean isSystem = query.getIsSystem();
            if (isSystem != null && isSystem.booleanValue()) {
                predicates.add(builder.lessThanOrEqualTo((Expression)root.get("tenantId"), (Comparable)Long.valueOf(0L)));
            } else if (query.getTenantId() != null && query.getTenantId() > 0L) {
                predicates.add(builder.equal((Expression)root.get("tenantId"), (Object)query.getTenantId()));
            }
            if (!predicates.isEmpty()) {
                criteriaQuery.where((Predicate[])predicates.stream().toArray(Predicate[]::new));
            }
            if (joinTable) {
                if (criteriaQuery.getResultType().isAssignableFrom(Long.class)) {
                    criteriaQuery.distinct(true);
                    return criteriaQuery.getRestriction();
                }
                criteriaQuery.groupBy(new Expression[]{root.get("id")});
                return criteriaQuery.getGroupRestriction();
            }
            return criteriaQuery.getRestriction();
        };
        return specification;
    }

    public static Specification<Role> queryOneSpecification(RoleModel.Request.Query query) {
        Specification & Serializable specification = (Specification & Serializable)(root, criteriaQuery, builder) -> {
            ArrayList<Predicate> predicates = new ArrayList<Predicate>();
            if (query.getId() != null && query.getId() > 0L) {
                predicates.add(builder.equal((Expression)root.get("id"), (Object)query.getId()));
            } else {
                if (StringUtils.isNotBlank((CharSequence)query.getRoleCode())) {
                    predicates.add(builder.equal((Expression)root.get("code"), (Object)query.getRoleCode()));
                }
                if (StringUtils.isNotBlank((CharSequence)query.getRoleName())) {
                    predicates.add(builder.equal((Expression)root.get("name"), (Object)query.getRoleName()));
                }
            }
            Boolean isSystem = query.getIsSystem();
            if (isSystem != null && isSystem.booleanValue()) {
                predicates.add(builder.lessThanOrEqualTo((Expression)root.get("tenantId"), (Comparable)Long.valueOf(0L)));
            } else if (query.getTenantId() != null && query.getTenantId() > 0L) {
                predicates.add(builder.equal((Expression)root.get("tenantId"), (Object)query.getTenantId()));
            }
            if (!predicates.isEmpty()) {
                criteriaQuery.where((Predicate[])predicates.stream().toArray(Predicate[]::new));
            }
            return criteriaQuery.getRestriction();
        };
        return specification;
    }

    public static Specification<RoleUserRel> queryRoleUserRelSpecification(Long tenantId, Long roleId, Long userId) {
        Specification & Serializable specification = (Specification & Serializable)(root, criteriaQuery, builder) -> {
            ArrayList<Predicate> predicates = new ArrayList<Predicate>();
            if (tenantId != null && tenantId > 0L) {
                predicates.add(builder.equal((Expression)root.get("tenantId"), (Object)tenantId));
            }
            if (roleId != null && roleId > 0L) {
                predicates.add(builder.equal((Expression)root.get("roleId"), (Object)roleId));
            }
            if (userId != null && userId > 0L) {
                predicates.add(builder.equal((Expression)root.get("userId"), (Object)userId));
            }
            if (!predicates.isEmpty()) {
                criteriaQuery.where((Predicate[])predicates.stream().toArray(Predicate[]::new));
            }
            return criteriaQuery.getRestriction();
        };
        return specification;
    }
}

