/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.query;

import com.xforceplus.api.model.ServicePackageModel;
import com.xforceplus.entity.ServicePackage;
import java.io.Serializable;
import java.util.ArrayList;
import javax.persistence.criteria.Expression;
import javax.persistence.criteria.Join;
import javax.persistence.criteria.JoinType;
import javax.persistence.criteria.ListJoin;
import javax.persistence.criteria.Predicate;
import org.apache.commons.lang3.StringUtils;
import org.springframework.data.jpa.domain.Specification;

public class ServicePackageQueryHelper {
    public static Specification<ServicePackage> querySpecification(ServicePackageModel.Request.Query query) {
        Specification & Serializable specification = (Specification & Serializable)(root, criteriaQuery, builder) -> {
            ArrayList<Predicate> predicates = new ArrayList<Predicate>();
            boolean joinTable = false;
            if (query.getTenantId() != null && query.getTenantId() > 0L || StringUtils.isNotBlank((CharSequence)query.getTenantCode()) || query.getCompanyId() != null && query.getCompanyId() > 0L) {
                ListJoin joinCompanyServiceRels = root.joinList("companyServiceRels", JoinType.LEFT);
                if (query.getTenantId() != null && query.getTenantId() > 0L) {
                    predicates.add(builder.equal((Expression)joinCompanyServiceRels.get("tenantId"), (Object)query.getTenantId()));
                } else if (StringUtils.isNotBlank((CharSequence)query.getTenantCode())) {
                    predicates.add(builder.equal((Expression)joinCompanyServiceRels.join("tenant", JoinType.LEFT).get("tenantCode"), (Object)query.getTenantCode()));
                }
                if (query.getCompanyId() != null && query.getCompanyId() > 0L) {
                    predicates.add(builder.equal((Expression)joinCompanyServiceRels.get("companyId"), (Object)query.getCompanyId()));
                }
                if (query.getStatus() != null) {
                    predicates.add(builder.equal((Expression)joinCompanyServiceRels.get("status"), (Object)query.getStatus()));
                }
                joinTable = true;
            }
            if (query.getResourcesetId() != null && query.getResourcesetId() > 0L || StringUtils.isNotBlank((CharSequence)query.getResourcesetName()) || StringUtils.isNotBlank((CharSequence)query.getResourcesetCode())) {
                ListJoin joinServiceResourcesetRels = root.joinList("serviceResourcesetRels", JoinType.LEFT);
                if (query.getResourcesetId() != null && query.getResourcesetId() > 0L) {
                    predicates.add(builder.equal((Expression)joinServiceResourcesetRels.get("resourcesetId"), (Object)query.getResourcesetId()));
                }
                if (StringUtils.isNotBlank((CharSequence)query.getResourcesetName()) || StringUtils.isNotBlank((CharSequence)query.getResourcesetCode())) {
                    Join joinResourceset = joinServiceResourcesetRels.join("resourceset", JoinType.LEFT);
                    if (StringUtils.isNotBlank((CharSequence)query.getResourcesetName())) {
                        predicates.add(builder.like((Expression)joinResourceset.get("resourcesetName"), query.getResourcesetName() + "%"));
                    }
                    if (StringUtils.isNotBlank((CharSequence)query.getResourcesetCode())) {
                        predicates.add(builder.like((Expression)joinResourceset.get("resourcesetCode"), query.getResourcesetCode() + "%"));
                    }
                    if (query.getStatus() != null && query.getStatus() == 1) {
                        predicates.add(builder.equal((Expression)joinResourceset.get("status"), (Object)1));
                    }
                }
                joinTable = true;
            }
            if (query.getServicePackageId() != null && query.getServicePackageId() > 0L) {
                predicates.add(builder.equal((Expression)root.get("servicePackageId"), (Object)query.getServicePackageId()));
            }
            if (StringUtils.isNotBlank((CharSequence)query.getServicePackageName())) {
                predicates.add(builder.like((Expression)root.get("servicePackageName"), "%" + query.getServicePackageName() + "%"));
            }
            if (StringUtils.isNotBlank((CharSequence)query.getServicePackageCode())) {
                predicates.add(builder.like((Expression)root.get("servicePackageCode"), query.getServicePackageCode() + "%"));
            }
            if (query.getAppId() != null && query.getAppId() > 0L) {
                predicates.add(builder.equal((Expression)root.get("appId"), (Object)query.getAppId()));
            }
            if (query.getStatus() != null) {
                predicates.add(builder.equal((Expression)root.get("status"), (Object)query.getStatus()));
            }
            if (!predicates.isEmpty()) {
                criteriaQuery.where((Predicate[])predicates.stream().toArray(Predicate[]::new));
            }
            if (joinTable) {
                if (criteriaQuery.getResultType().isAssignableFrom(Long.class)) {
                    criteriaQuery.distinct(true);
                    return criteriaQuery.getRestriction();
                }
                criteriaQuery.groupBy(new Expression[]{root.get("servicePackageId")});
                return criteriaQuery.getGroupRestriction();
            }
            return criteriaQuery.getRestriction();
        };
        return specification;
    }

    public static Specification<ServicePackage> queryOneSpecification(ServicePackageModel.Request.Query query) {
        Specification & Serializable specification = (Specification & Serializable)(root, criteriaQuery, builder) -> {
            ArrayList<Predicate> predicates = new ArrayList<Predicate>();
            if (query.getServicePackageId() != null && query.getServicePackageId() > 0L) {
                predicates.add(builder.equal((Expression)root.get("servicePackageId"), (Object)query.getServicePackageId()));
            } else if (StringUtils.isNotBlank((CharSequence)query.getServicePackageCode())) {
                predicates.add(builder.equal((Expression)root.get("servicePackageCode"), (Object)query.getServicePackageCode()));
            } else {
                if (StringUtils.isNotBlank((CharSequence)query.getServicePackageName())) {
                    predicates.add(builder.equal((Expression)root.get("servicePackageName"), (Object)query.getServicePackageName()));
                }
                if (query.getAppId() != null && query.getAppId() > 0L) {
                    predicates.add(builder.equal((Expression)root.get("appId"), (Object)query.getAppId()));
                }
            }
            if (!predicates.isEmpty()) {
                criteriaQuery.where((Predicate[])predicates.stream().toArray(Predicate[]::new));
            }
            return criteriaQuery.getRestriction();
        };
        return specification;
    }
}

