package com.xforceplus.utils;

import org.apache.commons.lang3.StringUtils;

import java.util.regex.Pattern;

/***
 * @author geewit
 */
@SuppressWarnings("all")
public class RegExUtil {
    /**
     * Email Reg 正则表达式 {@value}
     */
    public static final String REG_EMAIL = "^[a-zA-Z0-9_-]+(\\.[a-zA-Z0-9_-]+)*(\\.)?@[a-zA-Z0-9_-]+(\\.[a-zA-Z0-9_-]+)+$";
    /**
     * 手机号 正则表达式 {@value}
     */
    public static final String REG_PHONE_NO = "^1\\d{10}$";

    /**
     * 身份证号码 regex.
     */
    public static final String REG_ID_CARD = "(^\\d{17}[0-9Xx]$|\\d{15})";

    public static boolean checkEmail(String email) {
        if (StringUtils.isBlank(email)) {
            return false;
        }
        return Pattern.matches(REG_EMAIL, email);
    }

    public static boolean checkMobile(String mobile) {
        if (StringUtils.isBlank(mobile)) {
            return false;
        }
        return Pattern.matches(REG_PHONE_NO, mobile);
    }

    public static boolean checkIdCard(String idCard) {
        if (StringUtils.isBlank(idCard)) {
            return false;
        }
        return Pattern.matches(REG_ID_CARD, idCard);
    }
}
