package com.xforceplus.utils.password;


import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import java.security.MessageDigest;


@SuppressWarnings("AlibabaClassNamingShouldBeCamel")
public class MD5PwdUtil {
    private final static Logger logger = LoggerFactory.getLogger(MD5PwdUtil.class);

    private static final char[] HEX_DIGITS = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F'};

    public MD5PwdUtil() {
    }

    private static String toHexString(byte[] b) {
        StringBuilder sb = new StringBuilder(b.length * 2);
        for (byte value : b) {
            sb.append(HEX_DIGITS[(value & 240) >>> 4]);
            sb.append(HEX_DIGITS[value & 15]);
        }
        return sb.toString();
    }

    public static String encode(String sourceString) {
        String result = null;
        try {
            MessageDigest digest = MessageDigest.getInstance("MD5");
            digest.update(sourceString.getBytes());
            byte[] messageDigest = digest.digest();
            result = toHexString(messageDigest);
        } catch (Exception e) {
            logger.warn("MD5转码失败！", e);
        }

        return result;
    }
}
