/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.utils;

import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.LongAdder;

public class ExecutorUtils {
    private static final LongAdder THREAD_NAME_NUMBER = new LongAdder();

    private ExecutorUtils() {
    }

    public static void shutdownAndAwaitTermination(ExecutorService pool) {
        ExecutorUtils.shutdownAndAwaitTermination(pool, 60L);
    }

    public static void shutdownAndAwaitTermination(ExecutorService pool, long timeoutSec) {
        pool.shutdown();
        try {
            if (!pool.awaitTermination(timeoutSec, TimeUnit.SECONDS)) {
                pool.shutdownNow();
                if (!pool.awaitTermination(timeoutSec, TimeUnit.SECONDS)) {
                    System.err.println("Pool did not terminate.");
                }
            }
        }
        catch (InterruptedException ie) {
            pool.shutdownNow();
            Thread.currentThread().interrupt();
        }
    }

    public static ThreadFactory buildNameThreadFactory(String name) {
        return ExecutorUtils.buildNameThreadFactory(name, false);
    }

    public static ThreadFactory buildNameThreadFactory(String name, boolean daemon) {
        return r -> {
            Thread newThread = Executors.defaultThreadFactory().newThread(r);
            newThread.setName(String.format("%s-%d", name, THREAD_NAME_NUMBER.intValue()));
            newThread.setDaemon(daemon);
            THREAD_NAME_NUMBER.increment();
            return newThread;
        };
    }
}

