/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.utils;

import java.util.regex.Pattern;
import org.apache.commons.lang3.StringUtils;

public class RegExUtil {
    public static final String REG_EMAIL = "^[a-zA-Z0-9_-]+(\\.[a-zA-Z0-9_-]+)*(\\.)?@[a-zA-Z0-9_-]+(\\.[a-zA-Z0-9_-]+)+$";
    public static final Pattern REG_EMAIL_PATTERN = Pattern.compile("^[a-zA-Z0-9_-]+(\\.[a-zA-Z0-9_-]+)*(\\.)?@[a-zA-Z0-9_-]+(\\.[a-zA-Z0-9_-]+)+$");
    public static final String REG_PHONE_NO = "^1\\d{10}$";
    public static final Pattern REG_PHONE_NO_PATTERN = Pattern.compile("^1\\d{10}$");
    public static final String REG_ID_CARD = "(^\\d{17}[0-9Xx]$|\\d{15})";
    public static final Pattern REG_ID_CARD_PATTERN = Pattern.compile("(^\\d{17}[0-9Xx]$|\\d{15})");

    public static boolean checkEmail(String email) {
        if (StringUtils.isBlank((CharSequence)email)) {
            return false;
        }
        return Pattern.matches(REG_EMAIL, email);
    }

    public static boolean checkMobile(String mobile) {
        if (StringUtils.isBlank((CharSequence)mobile)) {
            return false;
        }
        return REG_PHONE_NO_PATTERN.matcher(mobile).matches();
    }

    public static boolean checkIdCard(String idCard) {
        if (StringUtils.isBlank((CharSequence)idCard)) {
            return false;
        }
        return REG_ID_CARD_PATTERN.matcher(idCard).matches();
    }

    public static boolean isDomainAccount(String account) {
        if (StringUtils.isBlank((CharSequence)account)) {
            return false;
        }
        return !RegExUtil.checkEmail(account) && !RegExUtil.checkMobile(account);
    }
}

