/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.utils.iterator;

import com.xforceplus.utils.iterator.DataIterator;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public abstract class AbstractDataIterator<E>
implements DataIterator<E> {
    private int buffSize;
    private List<E> buff;
    private long cursor;
    private boolean more;

    public AbstractDataIterator(int buffSize) {
        this.buff = buffSize > 0 ? new ArrayList(buffSize) : Collections.emptyList();
        this.buffSize = buffSize;
        this.cursor = 0L;
        this.more = true;
    }

    public long getCursor() {
        return this.cursor;
    }

    public int getBuffSize() {
        return this.buffSize;
    }

    @Override
    public boolean hasNext() {
        if (this.buff.isEmpty()) {
            if (!this.more) {
                return false;
            }
            try {
                this.load(this.buff, this.getBuffSize());
            }
            catch (Exception e) {
                throw new RuntimeException(e.getMessage(), e);
            }
            this.more = this.buff.size() >= this.getBuffSize();
        }
        return !this.buff.isEmpty();
    }

    @Override
    public E next() {
        E e = this.buff.remove(0);
        ++this.cursor;
        return e;
    }

    public boolean more() {
        return this.more;
    }

    protected abstract void load(List<E> var1, int var2) throws Exception;
}

