/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.utils.lock;

import com.xforceplus.utils.lock.AbstractResourceLocker;
import com.xforceplus.utils.lock.utils.Locker;
import com.xforceplus.utils.lock.utils.StateKeys;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;

public class LocalResourceLocker
extends AbstractResourceLocker {
    private final ConcurrentMap<String, LockInfo> lockPool = new ConcurrentHashMap<String, LockInfo>();
    private final boolean reentrant;

    public LocalResourceLocker() {
        this(true);
    }

    public LocalResourceLocker(boolean reentrant) {
        this.reentrant = reentrant;
    }

    @Override
    protected void doLocks(Locker locker, StateKeys stateKeys) {
        String[] keys = stateKeys.getNoCompleteKeys();
        for (int i = 0; i < keys.length; ++i) {
            String key = keys[i];
            LockInfo newLockInfo = new LockInfo(locker);
            LockInfo oldLockInfo = this.lockPool.putIfAbsent(key, newLockInfo);
            if (oldLockInfo != null) {
                if (!oldLockInfo.getLocker().equals(locker.getName())) {
                    return;
                }
                if (this.reentrant) {
                    oldLockInfo.incr();
                    stateKeys.completed(key);
                    continue;
                }
                return;
            }
            stateKeys.completed(key);
        }
    }

    @Override
    protected void doUnLocks(Locker locker, StateKeys stateKeys) {
        String[] keys = stateKeys.getNoCompleteKeys();
        for (int i = 0; i < keys.length; ++i) {
            String key = keys[i];
            LockInfo lockInfo = (LockInfo)this.lockPool.get(keys[i]);
            if (lockInfo != null) {
                if (!lockInfo.getLocker().equals(locker.getName())) continue;
                if (lockInfo.decr() == 0) {
                    this.lockPool.remove(key);
                }
                stateKeys.completed(key);
                continue;
            }
            stateKeys.completed(key);
        }
    }

    @Override
    protected boolean doIsLocking(String key) {
        return this.lockPool.containsKey(key);
    }

    private static class LockInfo {
        private String locker;
        private int number;

        public LockInfo(Locker locker) {
            this.locker = locker.getName();
            this.number = 1;
        }

        public String getLocker() {
            return this.locker;
        }

        public int getNumber() {
            return this.number;
        }

        public int incr() {
            return ++this.number;
        }

        public int decr() {
            --this.number;
            if (this.number < 0) {
                this.number = 0;
            }
            return this.number;
        }
    }
}

