/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.utils.lock.utils;

import com.xforceplus.utils.lock.utils.Locker;

public class LockerSupport {
    public static final String LOCK_KEY_PREFIX = "#l.";
    private static final ThreadLocal<Locker> THREAD_LOCAL = new ThreadLocal();

    public static String buildLockKey(String resource) {
        return LOCK_KEY_PREFIX.concat(resource);
    }

    public static String parseResourceFormLockKey(String lockKey) {
        return lockKey.substring(LOCK_KEY_PREFIX.length());
    }

    public static Locker getLocker() {
        Locker locker = THREAD_LOCAL.get();
        if (locker == null) {
            locker = new Locker();
            THREAD_LOCAL.set(locker);
        }
        return locker;
    }

    public static void cleanLockerIfCan() {
        Locker locker = THREAD_LOCAL.get();
        if (locker != null && locker.getSuccessLockNumber() <= 0) {
            THREAD_LOCAL.remove();
        }
    }
}

