/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.utils.lock.utils;

import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;

public class StateKeys
implements Serializable {
    private final Map<String, Boolean> keyStatus;

    public StateKeys(String ... keys) {
        this.keyStatus = new HashMap<String, Boolean>(StateKeys.calculateInitSize(keys.length));
        for (String key : keys) {
            this.keyStatus.put(key, false);
        }
    }

    private StateKeys(Map<String, Boolean> soruceKeyStatus) {
        this.keyStatus = new HashMap<String, Boolean>(StateKeys.calculateInitSize(soruceKeyStatus.size()));
        this.keyStatus.putAll(soruceKeyStatus);
    }

    public void completed(String key) {
        if (this.keyStatus.containsKey(key)) {
            this.keyStatus.put(key, true);
        }
    }

    public String[] getNoCompleteKeys() {
        return this.getKeys(false);
    }

    public String[] getCompleteKeys() {
        return this.getKeys(true);
    }

    public int size() {
        return this.keyStatus.size();
    }

    public boolean isCompleteness() {
        return this.getCompleteKeys().length == this.keyStatus.size();
    }

    public StateKeys copy() {
        return new StateKeys(this.keyStatus);
    }

    private String[] getKeys(boolean completeness) {
        return (String[])this.keyStatus.entrySet().stream().filter(e -> (Boolean)e.getValue() == completeness).map(Map.Entry::getKey).toArray(String[]::new);
    }

    private static int calculateInitSize(int size) {
        return (int)((float)size + (float)size * 0.25f);
    }
}

