/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.utils.polymerizer;

import com.xforceplus.utils.polymerizer.PolymerizerBehavior;
import com.xforceplus.utils.polymerizer.PolymerizerStrategy;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.function.Consumer;

public class Polymerizer<T> {
    private List<T> dataPool;
    private List<PolymerizerStrategy> strategies;

    public Polymerizer(List<PolymerizerStrategy> strategies) {
        this.strategies = strategies;
        this.dataPool = new LinkedList<T>();
    }

    public int size() {
        return this.dataPool.size();
    }

    public boolean isEmpty() {
        return this.dataPool.isEmpty();
    }

    public Collection<T> polymerize(T newData) {
        if (this.dataPool.isEmpty()) {
            this.dataPool.add(newData);
            return Collections.emptyList();
        }
        block5: for (PolymerizerStrategy strategy : this.strategies) {
            PolymerizerBehavior behavior = strategy.check(this.dataPool, newData);
            switch (behavior) {
                case BEFORE_ADD: {
                    ArrayList<T> resultList = new ArrayList<T>(this.dataPool);
                    this.dataPool.clear();
                    this.dataPool.add(newData);
                    return resultList;
                }
                case AFTER_ADD: {
                    this.dataPool.add(newData);
                    ArrayList<T> resultList = new ArrayList<T>(this.dataPool);
                    this.dataPool.clear();
                    return resultList;
                }
                case SILENCE: {
                    continue block5;
                }
            }
            throw new IllegalStateException("Unknown behavior.");
        }
        this.dataPool.add(newData);
        return Collections.emptyList();
    }

    public void polymerize(T newData, Consumer<Collection<T>> consumer) {
        Collection<T> result = this.polymerize(newData);
        if (!result.isEmpty()) {
            consumer.accept(result);
        }
    }

    public Collection<T> clean() {
        if (this.dataPool.isEmpty()) {
            return Collections.emptyList();
        }
        try {
            ArrayList<T> arrayList = new ArrayList<T>(this.dataPool);
            return arrayList;
        }
        finally {
            this.dataPool.clear();
        }
    }

    public void clean(Consumer<Collection<T>> consumer) {
        try {
            if (!this.dataPool.isEmpty()) {
                consumer.accept(new ArrayList<T>(this.dataPool));
            }
        }
        finally {
            this.dataPool.clear();
        }
    }
}

