/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.utils.polymerizer.strategy;

import com.xforceplus.utils.polymerizer.PolymerizerBehavior;
import com.xforceplus.utils.polymerizer.PolymerizerStrategy;
import java.util.Collection;
import java.util.function.Function;

public class AttributeSwitchPolymerizerStrategy
implements PolymerizerStrategy {
    private Function<Object, Object> parser;

    public AttributeSwitchPolymerizerStrategy(Function<Object, Object> parser) {
        this.parser = parser;
    }

    @Override
    public PolymerizerBehavior check(Collection data, Object newData) {
        if (data.isEmpty()) {
            return PolymerizerBehavior.SILENCE;
        }
        Object oldAttr = this.parser.apply(data.iterator().next());
        Object newAttr = this.parser.apply(newData);
        if (oldAttr == null && newAttr == null) {
            return PolymerizerBehavior.SILENCE;
        }
        if (oldAttr == null && newAttr != null) {
            return PolymerizerBehavior.BEFORE_ADD;
        }
        if (oldAttr != null && newAttr == null) {
            return PolymerizerBehavior.BEFORE_ADD;
        }
        if (oldAttr.equals(newAttr)) {
            return PolymerizerBehavior.SILENCE;
        }
        return PolymerizerBehavior.BEFORE_ADD;
    }
}

