/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.utils.progress;

import com.xforceplus.utils.progress.Progress;
import com.xforceplus.utils.progress.ProgressChange;
import com.xforceplus.utils.progress.ProgressFinished;
import com.xforceplus.utils.progress.ProgressNotification;
import com.xforceplus.utils.progress.ProgressWrong;
import java.util.function.Consumer;

public class DefaultProgress<T>
implements Progress<T> {
    private final Object lock = new Object();
    private float progress;
    private long totalNumber;
    private long currentNumber;
    private T value;
    private Throwable error;
    private Consumer<ProgressNotification> notificationConsumer;

    public static <T> DefaultProgress<T> buildNoTotal(Consumer<ProgressNotification> notification) {
        DefaultProgress<T> progress = new DefaultProgress<T>();
        if (notification != null) {
            progress.registerAnnunciator(notification);
        }
        return progress;
    }

    public static <T> DefaultProgress<T> build(long total) {
        return DefaultProgress.build(total, null);
    }

    public static <T> DefaultProgress<T> build(long total, Consumer<ProgressNotification> notification) {
        DefaultProgress<T> progress = new DefaultProgress<T>();
        progress.reset(total);
        if (notification != null) {
            progress.registerAnnunciator(notification);
        }
        return progress;
    }

    @Override
    public float incr(long incr) {
        this.checkComplete();
        float old = this.progress;
        this.reCalculation(incr);
        this.noticeChange(old, this.progress);
        return this.progress;
    }

    @Override
    public float currentProgress() {
        return this.progress;
    }

    @Override
    public void registerAnnunciator(Consumer<ProgressNotification> notice) {
        this.notificationConsumer = notice;
    }

    @Override
    public void complete(T value) {
        this.value = value;
        this.currentNumber = this.totalNumber;
        this.reCalculation(0L);
        this.noticeFinished();
    }

    @Override
    public void completeError(Throwable ex) {
        this.error = ex;
        this.currentNumber = this.totalNumber;
        this.reCalculation(0L);
        this.noticeErrorFinished();
    }

    @Override
    public void reset(long total) {
        this.currentNumber = 0L;
        this.totalNumber = total < 0L ? 0L : total;
        this.progress = 0.0f;
        this.value = null;
        this.reCalculation(0L);
    }

    private void noticeChange(float before, float after) {
        if (before == after) {
            return;
        }
        this.notice(new ProgressChange(before, after));
    }

    private void noticeFinished() {
        this.notice(new ProgressFinished<T>(this.value));
    }

    private void noticeErrorFinished() {
        this.notice(new ProgressWrong(this.error));
    }

    private void notice(ProgressNotification notification) {
        if (this.notificationConsumer != null) {
            this.notificationConsumer.accept(notification);
        }
    }

    private float truncateToTwoDecimalPlaces(float source) {
        return (float)((int)(source * 100.0f)) / 100.0f;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void reCalculation(long incr) {
        Object object = this.lock;
        synchronized (object) {
            this.currentNumber += incr;
            if (this.currentNumber < 0L) {
                this.currentNumber = 0L;
            }
            if (this.currentNumber > this.totalNumber) {
                this.currentNumber = this.totalNumber;
            } else {
                this.progress = this.currentNumber == this.totalNumber ? 1.0f : this.truncateToTwoDecimalPlaces((float)this.currentNumber / (float)this.totalNumber);
            }
        }
    }

    private void checkComplete() {
        if (this.value != null) {
            throw new IllegalStateException("The progress has already been completed.");
        }
    }
}

