/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.utils.serializable;

import com.caucho.hessian.io.Hessian2Input;
import com.caucho.hessian.io.Hessian2Output;
import com.caucho.hessian.io.SerializerFactory;
import com.xforceplus.utils.serializable.CanNotBeSerializedException;
import com.xforceplus.utils.serializable.CanNotBeUnSerializedException;
import com.xforceplus.utils.serializable.SerializeStrategy;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;

public class HessianSerializeStrategy
implements SerializeStrategy {
    private static final SerializerFactory SERIALIZER_FACTORY = new SerializerFactory();
    private static final HessianSerializeStrategy INSTANCE = new HessianSerializeStrategy();

    public static SerializeStrategy getInstance() {
        return INSTANCE;
    }

    @Override
    public byte[] serialize(Serializable source) throws CanNotBeSerializedException {
        ByteArrayOutputStream os = new ByteArrayOutputStream();
        Hessian2Output out = new Hessian2Output((OutputStream)os);
        out.setSerializerFactory(SERIALIZER_FACTORY);
        try {
            out.writeObject((Object)source);
            out.close();
        }
        catch (IOException ex) {
            throw new CanNotBeSerializedException(ex.getMessage(), ex);
        }
        return os.toByteArray();
    }

    @Override
    public <T extends Serializable> T unserialize(byte[] datas, Class<T> clazz) throws CanNotBeUnSerializedException {
        Object obj;
        ByteArrayInputStream os = new ByteArrayInputStream(datas);
        Hessian2Input input = new Hessian2Input((InputStream)os);
        input.setSerializerFactory(SERIALIZER_FACTORY);
        try {
            obj = input.readObject();
        }
        catch (IOException ex) {
            throw new CanNotBeUnSerializedException(ex.getMessage(), ex);
        }
        return (T)((Serializable)clazz.cast(obj));
    }
}

