/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.utils.serializable;

import com.xforceplus.utils.serializable.CanNotBeSerializedException;
import com.xforceplus.utils.serializable.CanNotBeUnSerializedException;
import com.xforceplus.utils.serializable.SerializeStrategy;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;

public class JdkSerializeStrategy
implements SerializeStrategy {
    private static final JdkSerializeStrategy INSTANCE = new JdkSerializeStrategy();

    public static SerializeStrategy getInstance() {
        return INSTANCE;
    }

    @Override
    public byte[] serialize(Serializable source) throws CanNotBeSerializedException {
        try {
            return JdkSerializeStrategy.objectToByte(source);
        }
        catch (IOException ex) {
            throw new CanNotBeSerializedException(ex.getMessage(), ex);
        }
    }

    @Override
    public <T extends Serializable> T unserialize(byte[] datas, Class<T> clazz) throws CanNotBeUnSerializedException {
        try {
            return (T)((Serializable)clazz.cast(JdkSerializeStrategy.byteToObject(datas)));
        }
        catch (Exception ex) {
            throw new CanNotBeUnSerializedException(ex.getMessage(), ex);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static byte[] objectToByte(Object obj) throws IOException {
        ByteArrayOutputStream buff = new ByteArrayOutputStream();
        out.writeObject(obj);
        try (ObjectOutputStream out = new ObjectOutputStream(buff);){
            byte[] byArray = buff.toByteArray();
            return byArray;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Object byteToObject(byte[] b) throws IOException, ClassNotFoundException {
        ByteArrayInputStream buff = new ByteArrayInputStream(b);
        ObjectInputStream in = new ObjectInputStream(buff);
        Object obj = in.readObject();
        try {
            Object object = obj;
            return object;
        }
        finally {
            in.close();
        }
    }
}

