package com.xforceplus.domain;

import com.fasterxml.jackson.annotation.JsonIgnore;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Getter;
import lombok.Setter;
import lombok.ToString;

import java.util.Collection;

/**
 * @author geewit
 */
@ApiModel(value = "reactjs tree")
@Setter
@Getter
@ToString
public class TreeNode {


    /**
     * 产品服务包，功能集、资源码
     */
    @ApiModelProperty("type")
    @JsonIgnore
    public String type;
    @ApiModelProperty("key")
    private Long key;
    @JsonIgnore
    @ApiModelProperty("id")
    private String id;
    @ApiModelProperty("title")
    private String title;
    @ApiModelProperty("pid")
    @JsonIgnore
    private Long pid;
    @ApiModelProperty("parentKey")
    @JsonIgnore
    private String parentKey;
    @ApiModelProperty("children")
    private Collection<TreeNode> children;
    /**
     * 资源路径
     */
    @ApiModelProperty("path")
    @JsonIgnore
    private String path;

}
