package com.xforceplus.domain.company;

import com.fasterxml.jackson.annotation.JsonFormat;
import com.xforceplus.tenant.security.core.domain.ICreater;
import io.geewit.core.utils.enums.EnumMapUtils;
import io.geewit.core.utils.enums.Value;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Getter;
import lombok.Setter;
import lombok.ToString;
import org.springframework.format.annotation.DateTimeFormat;

import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Objects;

/***
 * 公司租户关联关系操作记录 Dto
 * @author geewit
 */
@ApiModel(value = "公司租户关联关系操作记录")
@Setter
@Getter
@ToString
public class CompanyTenantRelOperationDto implements ICreater {
    public static final int OPERATION_TYPE_INVITE = 0;
    public static final int OPERATION_TYPE_UNRELATE = 1;

    protected Long id;
    @ApiModelProperty(value = "所属租户主体公司id")
    protected Long invitingCompanyId;
    @ApiModelProperty(value = "所属租户主体公司名称")
    protected String invitingCompanyName;
    @ApiModelProperty(value = "关联公司id")
    protected Long companyId;
    @ApiModelProperty(value = "关联公司名称")
    protected String companyName;
    @ApiModelProperty(value = "关联公司编码")
    protected String companyCode;
    @ApiModelProperty(value = "关联公司税号")
    protected String taxNum;
    @ApiModelProperty(value = "关联租户id")
    protected Long tenantId;
    @ApiModelProperty(value = "关联租户名称")
    protected String tenantName;
    @ApiModelProperty(value = "关联租户代码")
    protected String tenantCode;
    @ApiModelProperty(value = "被关联租户id")
    protected Long relatedTenantId;
    @ApiModelProperty(value = "被关联租户名称")
    protected String relatedTenantName;
    @ApiModelProperty(value = "被关联租户代码")
    protected String relatedTenantCode;
    @ApiModelProperty(value = "被关联公司id")
    protected Long relatedCompanyId;
    @ApiModelProperty(value = "被关联公司税号")
    protected String relatedTaxNum;
    @ApiModelProperty(value = "被关联公司名称")
    protected String relatedCompanyName;
    @ApiModelProperty(value = "被关联公司编码")
    protected String relatedCompanyCode;
    @ApiModelProperty(value = "开关组合", notes = "发票数据:1, 结算单:2, 税控终端&税控设备: 4")
    protected Integer switches;
    @ApiModelProperty(value = "共享历史发票起始日期")
    @DateTimeFormat(pattern = "yyyy-MM-dd")
    @JsonFormat(pattern = "yyyy-MM-dd", timezone = "GMT+8")
    protected Date invoiceStartDate;
    @ApiModelProperty(value = "共享历史结算单起始日期")
    @DateTimeFormat(pattern = "yyyy-MM-dd")
    @JsonFormat(pattern = "yyyy-MM-dd", timezone = "GMT+8")
    protected Date statementStartDate;
    @ApiModelProperty(value = "操作类型", notes = "0:邀请关联, 1:取消关联")
    protected Integer operationType;
    @ApiModelProperty(value = "审核状态", notes = "0:待确认, 1:确认, 2:拒绝, 3:取消邀请")
    protected Integer status;
    @ApiModelProperty(value = "邀请备注")
    protected String inviteRemark;
    @ApiModelProperty(value = "审核备注")
    protected String auditRemark;
    @ApiModelProperty(value = "创建时间")
    @DateTimeFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss", timezone = "GMT+8")
    protected Date createTime;
    @ApiModelProperty(value = "创建人id")
    protected String createrId;
    @ApiModelProperty(value = "创建人名称")
    protected String createrName;
    @ApiModelProperty(value = "创建人租户id")
    protected Long createrTenantId;
    @ApiModelProperty(value = "创建人租户名称")
    protected String createrTenantName;
    @ApiModelProperty(value = "审核人id")
    protected Long auditorId;
    @ApiModelProperty(value = "审核人名称")
    protected String auditorName;
    @ApiModelProperty(value = "审核时间")
    @DateTimeFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss", timezone = "GMT+8")
    protected Date auditTime;
    @ApiModelProperty(value = "审核人租户id")
    protected Long auditorTenantId;
    @ApiModelProperty(value = "审核人租户名称")
    protected String auditorTenantName;
    @ApiModelProperty(value = "所属租户id")
    protected Long hostTenantId;
    @ApiModelProperty(value = "所属租户名称")
    protected String hostTenantName;
    @ApiModelProperty(value = "所属租户代码")
    protected String hostTenantCode;
    @ApiModelProperty(value = "开关组合列表", notes = "发票数据:1, 结算单:2, 税控终端&税控设备: 4")
    public List<Integer> getSwitchesList() {
        return Switch.toValues(this.switches);
    }
    @ApiModelProperty(value = "枚举化的开关组合Map")
    public Map<Switch, Boolean> getSwitchesMap() {
        return EnumMapUtils.toEnumMap(Switch.class, this.switches);
    }


    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof CompanyTenantRelOperationDto)) {
            return false;
        }
        CompanyTenantRelOperationDto that = (CompanyTenantRelOperationDto) o;
        return Objects.equals(this.id, that.id);
    }

    @Override
    public int hashCode() {
        return Objects.hash(id);
    }

    public enum Status implements Value {
        /**
         * 初始化, 待审核
         */
        INITED(0),
        /**
         * 已接受邀请
         */
        ACCEPTED(1),
        /**
         * 已拒绝邀请
         */
        REFUSED(2),
        /**
         * 已撤销邀请
         */
        CANCELED(3);

        private final int value;

        Status(int value) {
            this.value = value;
        }

        @Override
        public int value() {
            return value;
        }
    }
}
