package com.xforceplus.domain.company;

import com.fasterxml.jackson.annotation.JsonView;
import com.xforceplus.domain.org.OrgDto;
import io.geewit.core.jackson.view.View;
import io.swagger.annotations.ApiModelProperty;
import lombok.Getter;
import lombok.Setter;

import java.util.Objects;
import java.util.Set;

/**
 * @author geewit
 */
@Setter
@Getter
public class RelatedTenant<O extends OrgDto<O>> {
    @JsonView({View.class})
    @ApiModelProperty(value = "租户id")
    protected Long tenantId;

    @JsonView({View.class})
    @ApiModelProperty(value = "租户名称")
    protected String tenantName;

    @JsonView({View.class})
    @ApiModelProperty(value = "租户代码")
    protected String tenantCode;

    @JsonView({View.class})
    @ApiModelProperty(value = "所在组织集合")
    protected Set<O> orgs;

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof RelatedTenant)) {
            return false;
        }
        RelatedTenant<O> that = (RelatedTenant<O>) o;
        return getTenantId().equals(that.getTenantId());
    }

    @Override
    public int hashCode() {
        return Objects.hash(getTenantId());
    }
}
