package com.xforceplus.domain.log;

import com.fasterxml.jackson.annotation.JsonFormat;
import com.fasterxml.jackson.annotation.JsonView;
import com.xforceplus.enums.ActionCodeEnum;
import io.geewit.core.jackson.view.View;
import io.swagger.annotations.ApiModelProperty;
import org.springframework.format.annotation.DateTimeFormat;

import java.util.Date;

/**
 * 版权：    上海云砺信息科技有限公司
 * author:  duanhy
 * 创建时间: 2020/12/3 20:48
 * 功能描述:
 * 修改历史:
 */
public class SystemLogDTO {

    @ApiModelProperty("id")
    protected Long id;

    @ApiModelProperty("表名")
    protected String tableName;

    @ApiModelProperty("批次id")
    protected String batchId;

    @ApiModelProperty("租户ID")
    protected Long tenantId;

    @ApiModelProperty("操作主键ID")
    protected Long identityId;

    @ApiModelProperty("'操作业务类型：'")
    protected String businessType;

    @ApiModelProperty("' 操作类型:I U D")
    protected ActionCodeEnum actionCode;

    @ApiModelProperty("操作内容：json格式相关数据")
    protected String content;

    @ApiModelProperty("创建人ID")
    protected String createUserId;

    @ApiModelProperty("创建人姓名")
    protected String createUserName;

    @DateTimeFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss", timezone = "GMT+8")
    @JsonView({View.Info.class})
    @ApiModelProperty(value = "创建时间")
    protected Date createTime;

    @ApiModelProperty("请求ID")
    protected String loginId;

    @ApiModelProperty("备注")
    protected String remark;

    public Long getId() {
        return id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public String getTableName() {
        return tableName;
    }

    public void setTableName(String tableName) {
        this.tableName = tableName;
    }

    public String getBatchId() {
        return batchId;
    }

    public void setBatchId(String batchId) {
        this.batchId = batchId;
    }

    public Long getTenantId() {
        return tenantId;
    }

    public void setTenantId(Long tenantId) {
        this.tenantId = tenantId;
    }

    public Long getIdentityId() {
        return identityId;
    }

    public void setIdentityId(Long identityId) {
        this.identityId = identityId;
    }

    public String getBusinessType() {
        return businessType;
    }

    public void setBusinessType(String businessType) {
        this.businessType = businessType;
    }

    public ActionCodeEnum getActionCode() {
        return actionCode;
    }

    public void setActionCode(ActionCodeEnum actionCode) {
        this.actionCode = actionCode;
    }

    public String getContent() {
        return content;
    }

    public void setContent(String content) {
        this.content = content;
    }

    public String getCreateUserId() {
        return createUserId;
    }

    public void setCreateUserId(String createUserId) {
        this.createUserId = createUserId;
    }

    public String getCreateUserName() {
        return createUserName;
    }

    public void setCreateUserName(String createUserName) {
        this.createUserName = createUserName;
    }

    public Date getCreateTime() {
        return createTime;
    }

    public void setCreateTime(Date createTime) {
        this.createTime = createTime;
    }

    public String getLoginId() {
        return loginId;
    }

    public void setLoginId(String loginId) {
        this.loginId = loginId;
    }

    public String getRemark() {
        return remark;
    }

    public void setRemark(String remark) {
        this.remark = remark;
    }

    public SystemLogDTO batchId(String batchId) {
        this.batchId = batchId;
        return this;
    }

    public SystemLogDTO remark(String remark) {
        this.remark = remark;
        return this;
    }

    public SystemLogDTO businessType(String businessType) {
        this.businessType = businessType;
        return this;
    }
}
