package com.xforceplus.domain.org;

import com.fasterxml.jackson.annotation.*;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.fasterxml.jackson.databind.ser.std.ToStringSerializer;
import com.xforceplus.domain.company.Switch;
import com.xforceplus.tenant.security.core.domain.IOperator;
import com.xforceplus.tenant.security.core.domain.Org;
import io.geewit.core.jackson.view.View;
import io.geewit.core.utils.enums.EnumMapUtils;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Getter;
import lombok.Setter;
import org.springframework.format.annotation.DateTimeFormat;

import java.util.*;


/**
 * 组织
 *
 * @author geewit
 */
@SuppressWarnings("all")
@ApiModel("组织")
@Setter
@Getter
public class OrgDto<O extends OrgDto<O>> extends Org<O> implements IOperator {
    @JsonView(View.class)
    @ApiModelProperty(value = "组织描述")
    protected String orgDesc;

    @JsonView(View.class)
    @ApiModelProperty(value = "组织业务类型")
    protected String orgBizType;

    @JsonView(View.List.class)
    @ApiModelProperty(value = "租户名称")
    protected String tenantName;

    @JsonView(View.List.class)
    @ApiModelProperty(value = "租户code")
    protected String tenantCode;

    @ApiModelProperty(value = "上级组织名称")
    @JsonView(View.class)
    protected String parentName;

    @ApiModelProperty(value = "关联租户开关组合")
    @JsonView(View.class)
    protected Integer relatedSwitches;

    @ApiModelProperty(value = "启用状态", example = "1", notes = "1:启用, 0:注销")
    @JsonView(View.class)
    protected Integer status;

    @ApiModelProperty(value = "分级角色id")
    @JsonView(View.class)
    protected Long gradingRoleId;

    @ApiModelProperty(value = "默认组织角色id")
    @JsonView(View.class)
    protected Long defaultOrgRoleId;

    @ApiModelProperty(value = "公司审核状态", notes = "0:待审核，1:审核通过, 2:审核失败")
    @JsonView(View.class)
    protected Integer auditStatus;

    @ApiModelProperty(value = "状态启用时间")
    @JsonView(View.class)
    @DateTimeFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss", timezone = "GMT+8")
    protected Date enabledTime;

    @ApiModelProperty(value = "状态注销时间")
    @JsonView(View.class)
    @DateTimeFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss", timezone = "GMT+8")
    protected Date disabledTime;

    @JsonView({View.class})
    @ApiModelProperty(value = "创建时间")
    @DateTimeFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss", timezone = "GMT+8")
    protected Date createTime;

    @JsonView(View.class)
    @ApiModelProperty(value = "创建人id")
    protected String createrId;

    @JsonView(View.class)
    @ApiModelProperty(value = "创建人名称")
    protected String createrName;

    @JsonView(View.class)
    @ApiModelProperty(value = "更新人id")
    protected String updaterId;

    @JsonView(View.class)
    @ApiModelProperty(value = "更新人名称")
    protected String updaterName;

    @JsonView({View.class})
    @ApiModelProperty(value = "更新时间")
    @DateTimeFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss", timezone = "GMT+8")
    protected Date updateTime;

    @ApiModelProperty(value = "归属用户数量")
    @JsonView(View.class)
    protected Long userCount;

    @ApiModelProperty(value = "子节点数量")
    @JsonView(View.class)
    protected Long childrenCount;

    @ApiModelProperty(value = "用户绑定勾选状态")
    @JsonView(View.class)
    protected Boolean userBound;

    @ApiModelProperty("公司代码集合")
    @JsonInclude(JsonInclude.Include.NON_EMPTY)
    @JsonView(View.class)
    protected Set<String> companyNos;

    @JsonView(View.class)
    @JsonInclude(JsonInclude.Include.NON_EMPTY)
    @ApiModelProperty("组织扩展信息")
    protected Set<OrgExtensionDto> extensions;

    @JsonView(View.class)
    @JsonInclude(JsonInclude.Include.NON_EMPTY)
    @ApiModelProperty("父级组织集合")
    protected List<O> parentOrgs;

    @JsonView(View.class)
    @JsonInclude(JsonInclude.Include.NON_EMPTY)
    @ApiModelProperty("后辈集合")
    protected List<O> descendants;

    @JsonView(View.class)
    @JsonInclude(JsonInclude.Include.NON_EMPTY)
    @ApiModelProperty("祖辈集合")
    protected List<O> ancestors;

    @ApiModelProperty("分级角色code")
    protected String gradingRoleCode;

    @ApiModelProperty("分级角色名称")
    protected String gradingRoleName;

    @ApiModelProperty("默认组织角色code")
    protected String defaultOrgRoleCode;

    @ApiModelProperty("默认组织角色名称")
    protected String defaultOrgRoleName;

    @JsonSerialize(using = ToStringSerializer.class)
    @Override
    public Long getOrgId() {
        return super.id;
    }

    @JsonSerialize(using = ToStringSerializer.class)
    @Override
    public Long getTenantId() {
        return tenantId;
    }

    @JsonSerialize(using = ToStringSerializer.class)
    @Override
    public Long getCompanyId() {
        return companyId;
    }

    @JsonSerialize(using = ToStringSerializer.class)
    @Override
    public Long getParentId() {
        return parentId;
    }

    @JsonView(View.List.class)
    @Override
    public String getTaxNum() {
        return super.taxNum;
    }

    @JsonView(View.List.class)
    @Override
    public String getCompanyName() {
        return super.companyName;
    }

    @ApiModelProperty(value = "公司code")
    @Override
    @JsonView(View.List.class)
    public String getCompanyCode() {
        return super.companyCode;
    }

    @JsonView(View.List.class)
    public String getGradingRoleName() {
        return gradingRoleName;
    }

    @JsonView(View.List.class)
    public String getDefaultOrgRoleName() {
        return defaultOrgRoleName;
    }

    @JsonView(View.List.class)
    public String getGradingRoleCode() {
        return gradingRoleCode;
    }

    @JsonView(View.List.class)
    public String getDefaultOrgRoleCode() {
        return defaultOrgRoleCode;
    }

    @ApiModelProperty(value = "枚举化的关联租户开关组合Map")
    @JsonInclude(JsonInclude.Include.NON_EMPTY)
    @JsonView(View.List.class)
    public Map<Switch, Boolean> getRelatedSwitchesMap() {
        if(this.relatedSwitches == null) {
            return Collections.emptyMap();
        }
        return EnumMapUtils.toEnumMap(Switch.class, this.relatedSwitches);
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof OrgDto)) {
            return false;
        }
        OrgDto that = (OrgDto) o;
        return Objects.equals(super.id, that.id) || (Objects.equals(super.tenantId, that.tenantId) && Objects.equals(super.orgCode, that.orgCode));
    }

    @Override
    public int hashCode() {
        if (super.id != null && super.id > 0) {
            return Objects.hash(super.id);
        }
        return Objects.hash(super.tenantId, super.orgCode);
    }
}
